<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$prevbra = false;
$rsm = $con->query("SELECT modulo FROM sc_tb_modulos WHERE modulo = 'prevbra' LIMIT 1");
if($rsm->rowCount() > 0){
	$prevbra = true;
}

if (!$prevbra){
	header('location:acomp.php');
}

//$usuario_busca = $_SESSION['login'];
$usuario_busca = 'admin';

$mostrar = isset($_GET["mostrar"]) ? (int) trim($_GET["mostrar"]) : 0;
$quadrimestre_geral = isset($_GET["qg"]) ? $_GET["qg"] : 0;
if ($quadrimestre_geral <= 0){
    $quadrimestre_gerado = 0;
    $rs = $con->prepare("SELECT quadrimestre FROM prevbra_tb_ind_gerado WHERE id = ? AND ibge = ? ORDER BY quadrimestre LIMIT 1");
    $rs->bindParam(1,$usuario_busca);
    $rs->bindParam(2,$_SESSION['ibge']);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $quadrimestre_gerado = $row->quadrimestre;
            }
        }
    }
    $quadrimestre_geral = $quadrimestre_gerado;
}

$titulo = "Indicador ".$mostrar;
$cfg_largura = $cfgeral_largura;
$cfg_altura = $cfgeral_altura;
$cfg_latitude = $cfgeral_latitude;
$cfg_longitude = $cfgeral_longitude;
$cfg_zoom = $cfgeral_zoom;
$cfg_tbtmp = $cfgeral_tbtmp;
$cfg_coorintacomp = $cfgeral_coorintacomp;
$cfg_metodo = $cfgeral_metodo;
$cfg_key_api_bing = $cfgeral_key_api_bing;

$rs = $con->prepare("SELECT * FROM maps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$cfg_largura = $row->largura;
			$cfg_altura = $row->altura;
			$cfg_latitude = $row->latitude;
			$cfg_longitude = $row->longitude;
			$cfg_zoom = $row->zoom;
			$cfg_tbtmp = $row->tbtmp;
			$cfg_coorintacomp = $row->coorintacomp;
			$cfg_metodo = $row->metodo;
			$cfg_key_api_bing = $row->key_api_bing;
		}
	}
}

if ($cfg_metodo == 0 && strlen($cfg_key_api_bing) <= 0){
	$cfg_key_api_bing = $cfgeral_key_api_bing2;
}

$prim_lat = $cfg_latitude;
$prim_lon = $cfg_longitude;
$prim_coord = true;

$matriz_casas = array();
$casas_ma = array();
$casas_ma_conta = 0;

$campo = array();
if ($mostrar == 123){
	$campo[0][0] = 'Indicador 1';  			$campo[0][1] = 'indicador1';  	$campo[0][2]  = 'gest1.png';   	$campo[0][3]  = 'gest2.png';
	$campo[1][0] = 'Indicador 1 (12 Sem.)'; $campo[1][1] = 'indicador11'; 	$campo[1][2]  = 'calend1.png';  $campo[1][3]  = 'calend2.png';
	$campo[2][0] = 'Indicador 1 (Cons.)'; 	$campo[2][1] = 'indicador12'; 	$campo[2][2]  = 'med1.png';   	$campo[2][3]  = 'med2.png';
	$campo[3][0] = 'Indicador 2';  			$campo[3][1] = 'indicador2'; 	$campo[3][2]  = 'teste2.png';  	$campo[3][3]  = 'teste3.png';
	$campo[4][0] = 'Indicador 2 (Sífilis)'; $campo[4][1] = 'indicador21'; 	$campo[4][2]  = 'teste4.png'; 	$campo[4][3]  = 'teste5.png';
	$campo[5][0] = 'Indicador 2 (HIV)'; 	$campo[5][1] = 'indicador22'; 	$campo[5][2]  = 'teste4.png'; 	$campo[5][3]  = 'teste5.png';
	$campo[6][0] = 'Indicador 3';  			$campo[6][1] = 'indicador3';  	$campo[6][2]  = 'dente1.png';  	$campo[6][3]  = 'dente2.png';
} elseif ($mostrar == 4){
	$campo[0][0] = 'Indicador 4'; 			$campo[0][1] = 'indicador4';	$campo[0][2]  = 'mulher1.png';  $campo[0][3]  = 'mulher2.png';
} elseif ($mostrar == 5){
	$campo[0][0] = 'Indicador 5'; 			$campo[0][1] = 'indicador5'; 	$campo[0][2]  = 'vac3.png';   	$campo[0][3]  = 'vac2.png';
	$campo[1][0] = 'Indicador 5 (Penta)';	$campo[1][1] = 'indicador51';	$campo[1][2]  = 'vac1.png';  	$campo[1][3]  = 'vac4.png';
	$campo[2][0] = 'Indicador 5 (Polio)';	$campo[2][1] = 'indicador52';	$campo[2][2]  = 'vac1.png';   	$campo[2][3]  = 'vac4.png';
	$campo[3][0] = 'Indicador 5 (Hexa)';	$campo[3][1] = 'indicador53';	$campo[3][2]  = 'vac1.png';  	$campo[3][3]  = 'vac4.png';
} elseif ($mostrar == 6){
	$campo[0][0] = 'Indicador 6'; 			$campo[0][1] = 'indicador6'; 	$campo[0][2]  = 'hiper4.png';   $campo[0][3]  = 'hiper5.png';
} elseif ($mostrar == 7){
	$campo[0][0] = 'Indicador 7'; 			$campo[0][1] = 'indicador7'; 	$campo[0][2]  = 'diab1.png';   	$campo[0][3]  = 'diab2.png';
}

include($path_local_raiz.'class/_cidadao.class.php');

if ($quadrimestre_geral > 0 && $mostrar > 0){
    $rs = $con->prepare("SELECT * FROM prevbra_tb_ind_gerado WHERE id = ? AND ibge = ? AND quadrimestre = ? AND indicador = ?");
    $rs->bindParam(1,$usuario_busca);
    $rs->bindParam(2,$_SESSION['ibge']);
	$rs->bindParam(3,$quadrimestre_geral);
	$rs->bindParam(4,$mostrar);
    if($rs->execute()){
        if($rs->rowCount() > 0){
			for ($c=0;$c<count($campo);$c++){
				$matriz_casas[$c][0] = "['".$campo[$c][0]." [S]', '".$campo[$c][1]."', '".$campo[$c][2]."','".$cfg_ma_cor_borda."','".$cfg_ma_cor_fundo."',".$cfg_ma_opacidade.",[";
				$matriz_casas[$c][1] = "['".$campo[$c][0]." [N]', '".$campo[$c][1]."', '".$campo[$c][3]."','".$cfg_ma_cor_borda."','".$cfg_ma_cor_fundo."',".$cfg_ma_opacidade.",[";
			}
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
				$lat = $row->latitude;
				$lon = $row->longitude;
				$lat = ($lat == 0) ? '' : $lat;
				$lon = ($lon == 0) ? '' : $lon;
				$pg_cor_internet = false;

				$casa_endereco = '';
				$cid_uf = '';
				$cid_cidade = '';
				$cid_bairro = '';
				$cid_logradouro = '';
				$cid_numero = '';
				$cid_complemento = '';
				$cid_tipoLogradouro = '';
				$cid_cep = '';

				if (strlen($lat) > 0 && strlen($lon) > 0){
					if ($prim_coord){
						$prim_lat = $lat;
						$prim_lon = $lon;
						$prim_coord = false;
					}
				} else {
					$cid = new CidadaoFAT($cdb, $row->cidadao);
					if ($cid->ok){
						$cid->dados();

						if (true){
							$ender = new Endereco($cdb, $cid->nome, $cid->mae, $cid->dtNascimento, $cid->cns, $cid->cpf, $cid->cnsResponsavel, $cid->cpfResponsavel);
							if ($ender->ok){
								$lat = $ender->latitude;
								$lon = $ender->longitude;

								$cid_uf = $ender->uf;
								$cid_cidade = $ender->cidade;
								$cid_bairro = $ender->bairro;
								$cid_logradouro = $ender->logradouro;
								$cid_numero = $ender->numero;
								$cid_complemento = $ender->complemento;
								$cid_tipoLogradouro = $ender->tipoLogradouro;
								$cid_cep = $ender->cep;
							}
						}
						$lat = ($lat == 0) ? '' : $lat;
						$lon = ($lon == 0) ? '' : $lon;
						$casa_endereco = $cid_tipoLogradouro.' '.$cid_logradouro.' '.$cid_numero.' '.$cid_cidade.' '.$cid_uf;
						$casa_endereco = tirap($casa_endereco);
						$casa_endereco = strtolower($casa_endereco);
						
						if ((strlen($lat) <= 0 || strlen($lon) <= 0) && $_SESSION['internet'] && $cfg_coorintacomp == 1){
							if ($cfg_metodo == 0 && strlen($cfg_key_api_bing) > 10){
								$mt0_endereco = $cid_uf."/".$cid_cidade."/".$cid_numero." ".$cid_logradouro;
								$mt0_endereco = urlencode($mt0_endereco);
								$mt0_url = "http://dev.virtualearth.net/REST/v1/Locations/BR/".$mt0_endereco."?output=xml&key=".$cfg_key_api_bing;
								$mt0_response = simplexml_load_file($mt0_url);
								$pg_cor_internet = true;
								$lat = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Point->Latitude;
								$lon = $mt0_response->ResourceSets->ResourceSet->Resources->Location->Point->Longitude;
							} else {
								$name_address = urlencode($casa_endereco);
								$baseUrl = 'http://nominatim.openstreetmap.org/search?format=json&q='.$name_address;
								$opts = array(
									'http' => array(
										'header' => "User-Agent:MyAgent/1.0\r\n"
									)
								); 
								$context = stream_context_create($opts);
								$data = @file_get_contents($baseUrl, false, $context);
								if($data === FALSE) { 
									// nao retornou nada
								} else {
									$json = json_decode($data);
									$trouxe_conteudo = true;
									if (empty($json)) {
										$trouxe_conteudo = false;
									}
									if ($trouxe_conteudo){
										$pg_cor_internet = true;
										$lat = $json[0]->lat;
										$lon = $json[0]->lon;
									}
								}
							}
						}
					}
				}
				$ctrl_dup = $row->nome.$row->mae.$row->dtNascimento.$lat.$lon;
				if (false !== $key = array_search($ctrl_dup, array_column($casas_ma, 'ctrl'))) {
					// encontrou duplicado
				} else {
					$casas_ma[$casas_ma_conta]['lat'] = $lat;
					$casas_ma[$casas_ma_conta]['lon'] = $lon;
					$casas_ma[$casas_ma_conta]['uf'] = $cid_uf;
					$casas_ma[$casas_ma_conta]['municipio'] = $cid_cidade;
					$casas_ma[$casas_ma_conta]['bairro'] = $cid_bairro;
					$casas_ma[$casas_ma_conta]['logradouro'] = $cid_logradouro;
					$casas_ma[$casas_ma_conta]['numero'] = $cid_numero;
					$casas_ma[$casas_ma_conta]['endereco'] = $casa_endereco;
					$casas_ma[$casas_ma_conta]['complemento'] = $cid_complemento;
					$casas_ma[$casas_ma_conta]['pginter'] = $pg_cor_internet;
					$casas_ma[$casas_ma_conta]['responsavel'] = $row->nome;
					$casas_ma[$casas_ma_conta]['mae'] = $row->mae;
					$casas_ma[$casas_ma_conta]['dtnas'] = $row->dtNascimento;
					$casas_ma[$casas_ma_conta]['marea'] = $row->ma;
					if ($mostrar == 123){
						$casas_ma[$casas_ma_conta]['situacao1'] = $row->indicador1;
						$casas_ma[$casas_ma_conta]['situacao2'] = $row->indicador2;
						$casas_ma[$casas_ma_conta]['situacao3'] = $row->indicador3;
					} else {
						$nome_campo_indicador = 'indicador'.$mostrar;
						$casas_ma[$casas_ma_conta]['situacao1'] = $row->$nome_campo_indicador;
						$casas_ma[$casas_ma_conta]['situacao2'] = '';
						$casas_ma[$casas_ma_conta]['situacao3'] = '';
					}

					$casas_ma[$casas_ma_conta]['ctrl'] = $ctrl_dup;
					$casas_ma_conta++;
				}
				if (strlen($lat) > 0 && strlen($lon) > 0){
					for ($c=0;$c<count($campo);$c++){
						$nome_campo = $campo[$c][1];
						if (strlen($nome_campo) > 0){
							if ($row->$nome_campo == 1){
								$matriz_casas[$c][0] .= "[".$lat.", ".$lon.", '<b>".$row->nome."</b><br>".$cid_tipoLogradouro." ".$cid_logradouro.", ".$cid_numero."<br>".$cid_cep." ".$cid_bairro." (".$cid_complemento.")<br>Microárea: ".$row->ma."'],";
							} else {
								$matriz_casas[$c][1] .= "[".$lat.", ".$lon.", '<b>".$row->nome."</b><br>".$cid_tipoLogradouro." ".$cid_logradouro.", ".$cid_numero."<br>".$cid_cep." ".$cid_bairro." (".$cid_complemento.")<br>Microárea: ".$row->ma."'],";
							}
						}
					}
				}
            }
			for ($c=0;$c<count($campo);$c++){
				$matriz_casas[$c][0] .= "]],";
				$matriz_casas[$c][1] .= "]],";
			}
        }
    }
}

?>
<link rel="stylesheet" type="text/css" href="mod/maps/leaflet/leaflet.css">

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Acompanhamento (PrevBra)</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Escolha um quadrimestre para ver o mapa</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">




					<div class="row g-1 mb-md-1">
						<div class="col-md-2">
							<label class="form-label"><b>Quadrimestre</b></label>
							<select class="form-select" aria-label="Default select example" name="qg" id="qg">
								<option value="<?php echo $quadrimestre_geral;?>" selected><?php echo substr($quadrimestre_geral,4,2).' / '.substr($quadrimestre_geral,0,4);?></option>
								<?php
									$ct_quadri = array();
									$rs = $con->prepare("SELECT quadrimestre FROM prevbra_tb_ind_gerado WHERE id = ? AND ibge = ? AND quadrimestre <> ? ORDER BY quadrimestre");
									$rs->bindParam(1,$usuario_busca);
									$rs->bindParam(2,$_SESSION['ibge']);
									$rs->bindParam(3,$quadrimestre_geral);
									if($rs->execute()){
										if($rs->rowCount() > 0){
											while($row = $rs->fetch(PDO::FETCH_OBJ)){
												if (!in_array($row->quadrimestre, $ct_quadri)) {
													echo "<option value=\"".$row->quadrimestre."\">".substr($row->quadrimestre,4,2).' / '.substr($row->quadrimestre,0,4)."</option>";
													$ct_quadri[] = $row->quadrimestre;
												} 
											}
										}
									}
								?>
							</select>
						</div>
						<div class="col-md-2">
							<label class="form-label"><b>Mostrar</b></label>
							<select class="form-select" aria-label="Default select example" name="mostrar" id="mostrar">
								<?php

									$ct_indicadores = array();
									for($a=0;$a<count($indicadores);$a++){
										if ($a > 0){
											$rs = $con->prepare("SELECT indicador FROM prevbra_tb_ind_gerado WHERE id = ? AND ibge = ? AND indicador = ? LIMIT 1");
											$rs->bindParam(1,$usuario_busca);
											$rs->bindParam(2,$_SESSION['ibge']);
											$rs->bindParam(3,$indicadores[$a]['vl']);
											if($rs->execute()){
												if($rs->rowCount() > 0){
													if ($mostrar == $indicadores[$a]['vl']){
														echo "<option value=\"".$indicadores[$a]['vl']."\" selected>".$indicadores[$a]['show']."</option>";
													} else {
														echo "<option value=\"".$indicadores[$a]['vl']."\">".$indicadores[$a]['show']."</option>";
													}
												}
											}
										} else {
											echo "<option value=\"".$indicadores[$a]['vl']."\">".$indicadores[$a]['show']."</option>";
										}
									}

								?>

							</select>
						</div>
						<button class="btn btn-warning col-md-4" type="button" id="tbtmpbt">Ver mapa</button>
					</div>




                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Mapa</h4>
                </div>
                <div class="card-body mt-2">

                  <div id='mapv' style="width: <?php echo $cfg_largura;?>; height: <?php echo $cfg_altura;?>;"></div>

                </div>
            </div>
        </div>
    </div>
</section>
<div id="resendereco" name="resendereco"></div>
<?php
if (strlen($mostrar) > 0){
?>
                <!-- Bordered table start -->
                <div class="row" id="table-bordered">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title"><?php echo $titulo;?></h4>
                            </div>
                            <div class="card-body">
                                <p class="card-text">
									<?php echo substr($quadrimestre_geral,4,2).' / '.substr($quadrimestre_geral,0,4);?>
                                </p>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
											<th>Situação</th>
                                            <th>Bairro</th>
                                            <th>Logradouro</th>
                                            <th>Número</th>
                                            <th>Complemento</th>
                                            <th>Cidadão</th>
											<th>Coordenadas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
									<?php
										for($i=0;$i<count($casas_ma);$i++){
											$td_coord = "<td><span class=\"badge rounded-pill badge-light-primary me-1\">".$casas_ma[$i]['lat']." ".$casas_ma[$i]['lon']."</span> ".$casas_ma[$i]['pginter']."<br><a href=\"https://maps.google.com/?q=".$casas_ma[$i]['lat'].",".$casas_ma[$i]['lon']."\" target=\"_blank\">Mapa</a></td>";
											if (strlen($casas_ma[$i]['lat']) <= 0 || strlen($casas_ma[$i]['lon']) <= 0){
												//$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><button onclick=\"vercoord('".urlencode($casas_ma[$i]['endereco'])."');\"><img src=\"mod/maps/img/mapa.png\"></button></td>";
												$td_coord = "<td><span class=\"badge rounded-pill badge-light-danger me-1\">Sem coordenadas</span><img src=\"mod/maps/img/mapa.png\" onclick=\"vercoord('".urlencode($casas_ma[$i]['endereco'])."');\"></td>";
											}
											$situacao = '';
											if ($mostrar == '123'){
												if ($casas_ma[$i]['situacao1'] == 1){
													$situacao = "<span class=\"badge rounded-pill badge-light-primary me-1\">S</span>";
												} else {
													$situacao = "<span class=\"badge rounded-pill badge-light-danger me-1\">N</span>";
												}
												if ($casas_ma[$i]['situacao2'] == 1){
													$situacao .= "<span class=\"badge rounded-pill badge-light-primary me-1\">S</span>";
												} else {
													$situacao .= "<span class=\"badge rounded-pill badge-light-danger me-1\">N</span>";
												}
												if ($casas_ma[$i]['situacao3'] == 1){
													$situacao .= "<span class=\"badge rounded-pill badge-light-primary me-1\">S</span>";
												} else {
													$situacao .= "<span class=\"badge rounded-pill badge-light-danger me-1\">N</span>";
												}
											} else {
												if ($casas_ma[$i]['situacao1'] == 1){
													$situacao = "<span class=\"badge rounded-pill badge-light-primary me-1\">SIM</span>";
												} else {
													$situacao = "<span class=\"badge rounded-pill badge-light-danger me-1\">NÃO</span>";
												}
											}
											echo "
											<tr>
												<td>".$situacao."</td>
												<td><span class=\"fw-bold\">".$casas_ma[$i]['bairro']."</span></td>
												<td><span class=\"fw-bold\">".$casas_ma[$i]['logradouro']."</span></td>
												<td>".$casas_ma[$i]['numero']."</td>
												<td>".$casas_ma[$i]['complemento']."</td>
												<td>".$casas_ma[$i]['responsavel']."<br>Mãe: ".$casas_ma[$i]['mae']."<br>Dt nas.: ".datanas6($casas_ma[$i]['dtnas'])."</td>
												".$td_coord."
											</tr>
											";
										}
									?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Bordered table end -->
<?php
}
?>


<script src="mod/maps/leaflet/leaflet.js"></script>
<script>

function vercoord(end) {
	var resultado = 'Latitude e longitude não encontrado!';
	$.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q=' + end, function(data){
		//alert(JSON.stringify(data));
		//var obj = JSON.parse(data);
		res = JSON.stringify(data);
		resultado = 'ID área: ' + data[0].place_id + '<br>';
		resultado += 'ID OSM: ' + data[0].osm_id + '<br>';
		resultado += 'Latitude: ' + data[0].lat + '<br>';
		resultado += 'Longitude: ' + data[0].lon + '<br>';
		resultado += 'Classe: ' + data[0].class + '<br>';
		resultado += 'Tipo: ' + data[0].type + '<br>';
		resultado += 'Completo: ' + data[0].display_name + '<br>';
		resultado += '<a href="https://maps.google.com/?q=' + data[0].lat + ',' + data[0].lon + '" target="_blank">Mapa</a><br>';
		resultado += 'Área: [' + data[0].boundingbox + ']<br>';
		toastr['success'](
			resultado,
			'Localização geográfica',        
			{
				closeButton: true,
				debug: false,
				newestOnTop: false,
				progressBar: false,
				positionClass: "toast-top-right",
				preventDuplicates: false,
				tapToDismiss: true,
				onclick: null,
				showDuration: "300",
				hideDuration: "1000",
				timeOut: "5000",
				extendedTimeOut: "1000",
				showEasing: "swing",
				hideEasing: "linear",
				showMethod: "fadeIn",
				hideMethod: "fadeOut"
			}
		);
	});
};

$(function () {

  SlickLoader.disable();

  const vLatitude = <?php echo $prim_lat;?>;
  const vLongitude = <?php echo $prim_lon;?>;
  const vZoom = <?php echo $cfg_zoom;?>;

  	let camadas = [
		<?php
			for ($c=0;$c<count($matriz_casas);$c++){
				echo $matriz_casas[$c][0];
				echo $matriz_casas[$c][1];
			}
		?>
	];

	const mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>';
	const mbUrl = 'https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
	const mbAttrOsm = '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>';
	const mbUrlOsm = 'https://tile.openstreetmap.org/{z}/{x}/{y}.png';
	const mbUrlCarto = 'https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png';
	const mbCarto = '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="https://carto.com/attribution">CARTO</a>';

	const positron = L.tileLayer(mbUrlCarto, {attribution: mbCarto});
	const streets = L.tileLayer(mbUrl, {id: 'mapbox/streets-v11', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const satellite = L.tileLayer(mbUrl, {id: 'mapbox/satellite-v9', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const osm = L.tileLayer(mbUrlOsm, {maxZoom: 19, attribution: mbAttrOsm});

	const LeafIcon = L.Icon.extend({
		options: {
			iconSize:     [24, 24],
			iconAnchor:   [22, 94],
			popupAnchor:  [-3, -76]
		}
	});
	const overlays = {};
	let lays = [];
	lays[0] = <?php echo $mapa_abertura;?>;

	let grupo = [];
	let icone = [];
	let itmap = [];
	//let polygon = [];
	var ct_itmap = 0;
	//let pontos_polig = [];
    for(var i = 0; i < camadas.length; i++) {
		grupo[i] = L.layerGroup();
		icone[i] = new LeafIcon({iconUrl: 'mod/maps/img/' + camadas[i][2]});
		overlays[camadas[i][0]] = grupo[i];
		lays[i+1] = grupo[i];
		//pontos_polig = [];
        for(var f = 0; f < camadas[i][6].length; f++) {
			itmap[ct_itmap] = L.marker([camadas[i][6][f][0], camadas[i][6][f][1]], {icon: icone[i]}).bindPopup(camadas[i][6][f][2] + '<br><a href="https://maps.google.com/?q=' + camadas[i][6][f][0] + ',' + camadas[i][6][f][1] + '" target="_blank">Mapa</a><br>' + camadas[i][6][f][0] + ',' + camadas[i][6][f][1]).addTo(grupo[i]);
			ct_itmap++;
			//pontos_polig[f] = [camadas[i][6][f][0], camadas[i][6][f][1]];
        }
		//polygon[i] = L.polygon([pontos_polig],{color: camadas[i][3], fillColor: camadas[i][4], fillOpacity: camadas[i][5]}).bindPopup(camadas[i][0]);
		//overlays['Área: ' + camadas[i][0]] = polygon[i];
    }

	if (typeof areas !== 'undefined') {
		let ipolygon = [];
		var index_layp = lays.length - 1;
		let pontos_polig_areai = [];
		for(var c = 0; c < areas.length; c++) {
			pontos_polig_areai = [];
			for(var f = 0; f < areas[c][7].length; f++) {
				pontos_polig_areai[f] = [areas[c][7][f][0], areas[c][7][f][1]];
			}
			ipolygon[c] = L.polygon([pontos_polig_areai],{color: areas[c][3], fillColor: areas[c][4], fillOpacity: areas[c][5]}).bindPopup(areas[c][0]);
			overlays['Área: ' + areas[c][0]] = ipolygon[c];
			index_layp = index_layp + 1;
			lays[index_layp] = ipolygon[c];
		}
	}



	const baseLayers = {
		'OpenStreetMap': osm,
		'Ruas': streets,
		'Satelite': satellite,
		'Mapa': positron
	};
	const map = L.map('mapv', {
		center: [vLatitude, vLongitude],
		zoom: vZoom,
		layers: lays
	});
	const layerControl = L.control.layers(baseLayers, overlays).addTo(map);

	const popup = L.popup();
	function onMapClick(e) {
    const ta1 = e.latlng.toString().split("(");
    const ta2 = ta1[1].split(",");
    const tLatitude = ta2[0].trim();
    const tLongitude = ta2[1].substring(0,ta2[1].length-1).trim();
		popup
			.setLatLng(e.latlng)
			.setContent('As coordenadas aqui são: ' + tLatitude + ', ' + tLongitude + '<br><a href="https://maps.google.com/?q=' + tLatitude + ',' + tLongitude + '" target="_blank">Mapa</a>')
			.openOn(map);
	}
	map.on('click', onMapClick);

	/*
	$("#btend").click(function() {
		$.get(location.protocol + '//nominatim.openstreetmap.org/search?format=json&q=' + $("#endereco").val(), function(data){
			//alert(JSON.stringify(data));
			//var obj = JSON.parse(data);
			var resultado = 'ID área: ' + data[0].place_id + '<br>';
			resultado += 'ID OSM: ' + data[0].osm_id + '<br>';
			resultado += 'Latitude: ' + data[0].lat + '<br>';
			resultado += 'Longitude: ' + data[0].lon + '<br>';
			resultado += 'Classe: ' + data[0].class + '<br>';
			resultado += 'Tipo: ' + data[0].type + '<br>';
			resultado += 'Completo: ' + data[0].display_name + '<br>';
			resultado += 'Área: ' + data[0].boundingbox + '<br>';
			$("#resendereco").html(resultado);
		});
	});
	*/

	$("#tbtmpbt").click(function() {
		SlickLoader.enable();
		$('.content-body').load('mod/maps/acomppb.php?qg=' + $("#qg").find(":selected").val() + '&mostrar=' + $('#mostrar').val());
	});





});




</script>