<?php

class PDF extends FPDF {
    public $veri;
    public $indic;
    public $scsusnm;
    // ***********************************************************************************************************
	var $angle=0;

	function Rotate($angle,$x=-1,$y=-1)
	{
		if($x==-1)
			$x=$this->x;
		if($y==-1)
			$y=$this->y;
		if($this->angle!=0)
			$this->_out('Q');
		$this->angle=$angle;
		if($angle!=0)
		{
			$angle*=M_PI/180;
			$c=cos($angle);
			$s=sin($angle);
			$cx=$x*$this->k;
			$cy=($this->h-$y)*$this->k;
			$this->_out(sprintf('q %.5F %.5F %.5F %.5F %.2F %.2F cm 1 0 0 1 %.2F %.2F cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
		}
	}

	function _endpage()
	{
		if($this->angle!=0)
		{
			$this->angle=0;
			$this->_out('Q');
		}
		parent::_endpage();
	}

    function RotatedText($x, $y, $txt, $angle) {
        //Text rotated around its origin
        $this->Rotate($angle,$x,$y);
        $this->Text($x,$y,$txt);
        $this->Rotate(0);
    }
    // ***********************************************************************************************************
    function Header() {
        $this->SetFillColor(160,160,160); // cor de fundo
        $this->SetDrawColor(160,160,160); // cor da linha (1 = linha total, LR = linha L e R)
        $this->SetTextColor(0,0,0); // cor da letra
        $this->SetLineWidth(.3);
        $this->SetFont('Arial','B',9);
        $this->Cell(110,6,'Indicador '.$this->indic,1,0,'C',1);
        $this->Ln(8);
    }
    function Footer() {
        // Vai para 1.5 cm da borda inferior
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,6,'['.$this->scsusnm.'] Pagina '.$this->PageNo(),0,0,'C');
        if ($this->veri == 23587){
            $this->SetFont('Arial','B',50);
            $this->SetTextColor(255,192,203);
            $this->RotatedText(35,190,'S C S U S   t e s t e',45);
        }
    }

    function getTable($cabeca, $data, $recuo, $cabecatm, $titulo) {
        $total_he = count($cabeca);
        // ******************************************************************************************************
        // ******************************************************************************************************
        // TITULO
        // ******************************************************************************************************
        // ******************************************************************************************************

        if (strlen($titulo) > 0){
            if ($recuo > 0){
                $this->Cell($recuo);
            }
            if ($total_he > 0){
                $tamanho_total = 0;
                for ($i=0;$i<$total_he;$i++){
                    $tamanho_total = $tamanho_total + $cabecatm[$i];
                }
                if ($tamanho_total > 0){
                    $this->SetFillColor(160,160,160); // cor de fundo
                    $this->SetDrawColor(160,160,160); // cor da linha (1 = linha total, LR = linha L e R)
                    $this->SetTextColor(0,0,0); // cor da letra
                    $this->SetLineWidth(.3);
                    $this->SetFont('', 'B');
                    $this->Cell($tamanho_total, 7, $titulo, 1, 0, 'L', true);
                    $this->Ln();
                }
            }
        }
        // ******************************************************************************************************
        // ******************************************************************************************************
        // CABECALHO
        // ******************************************************************************************************
        // ******************************************************************************************************

        if ($total_he > 0){
            if ($recuo > 0){
                $this->Cell($recuo);
            }
            $this->SetFillColor(192,192,192); // cor de fundo
            $this->SetDrawColor(160,160,160); // cor da linha (1 = linha total, LR = linha L e R)
            $this->SetTextColor(0,0,0); // cor da letra
            $this->SetLineWidth(.3);
            $this->SetFont('', 'B');
            for ($i=0;$i<$total_he;$i++){
                $this->Cell($cabecatm[$i], 7, $cabeca[$i], 1, 0, 'C', true);
            }
            $this->Ln();
        }
        // ******************************************************************************************************
        // ******************************************************************************************************
        // DADOS
        // ******************************************************************************************************
        // ******************************************************************************************************
        $this->SetFillColor(255,255,255); // cor de fundo
        $this->SetDrawColor(160,160,160); // cor da linha (1 = linha total, LR = linha L e R)
        $this->SetTextColor(0,0,0); // cor da letra
        $this->SetLineWidth(.3);
        $this->SetFont('');
        $nli = 1;
        foreach($data as $row) {
            if ($recuo > 0){
                $this->Cell($recuo);
            }
            if (($nli % 2) == 0){
                $this->SetFillColor(255,255,255);
            } else {
                $this->SetFillColor(224,224,224);
            }
            $nli++;
            $tamanho_total = $recuo;
            for ($i=0;$i<count($row);$i++){
                $tamanho_total = $tamanho_total + $cabecatm[$i];
                if (($nli % 2) == 0){
                    $this->SetFillColor(255,255,255);
                } else {
                    $this->SetFillColor(224,224,224);
                }
                $valor = $row[$i];
                if (str_contains($valor, ':')) {
                    $anvl = explode(':',$valor);
                    $valor = $anvl[0];
                    if ($valor == 0){
                        $valor = 'NAO';
                        $this->SetFillColor(255,51,51); // cor de fundo
                    } else {
                        $valor = 'SIM';
                        $this->SetFillColor(0,255,0); // cor de fundo
                    }
                }
                if (str_contains($valor, '|')) {
                    $bline = explode('|',$valor);
                    $tvalores = count($bline) - 1;
                    if ($tvalores > 1){
                        $distancia = $tamanho_total - $cabecatm[$i];
                        $conta_tvalores = 0;
                        foreach($bline as $nrow) {
                            if (strlen(trim($nrow)) > 0){
                                $conta_tvalores++;
                                $this->Cell($cabecatm[$i], 7, $nrow, 1, 0, 'C', true);
                                if ($conta_tvalores < $tvalores){
                                    $this->Ln();
                                    $this->Cell($distancia);
                                }
                            }
                        }
                    } else {
                        $this->Cell($cabecatm[$i], 7, $bline[0], 1, 0, 'C', true); 
                    }
                } else {
                    $this->Cell($cabecatm[$i], 7, $valor, 1, 0, 'C', true);
                }
            }
            $this->Ln();
        }
        // ******************************************************************************************************
        // ******************************************************************************************************
    }
  
}

?>