<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Cidadãos</h4>
                </div>
                <div class="card-body mt-2">
<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$f_calibra = "calibracao.php";
if (file_exists($f_calibra)){
    include $f_calibra;
}

$opcao = '';
$filtro = '';

$rs = $con->prepare("SELECT * FROM cidadao_tb_cf_cidadaos WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$opcao = $row->opcao;
			$filtro = $row->filtro;
		}
	}
}

$opcao_nome = '';
for ($i=0;$i<count($opcs);$i++){
    if ($opcs[$i][0] == $opcao){
        $opcao_nome = $opcs[$i][2];
    }
}

echo "
                    <p class=\"card-text\">
                        Opção: ".$opcao_nome."<br>
                        Filtro: ".$filtro."<br>
                        Gerado em: ".date('d/m/Y H:i:s')."
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
";

// --------------------------------------------------------

// --------------------------------------------------------


include($path_local_raiz.'class/_cidadao.class.php');
include($path_local_raiz.'class/_clinicos.class.php');

echo "
<table id=\"tbdt\" class=\"table table-striped\">
<thead>
    <tr>
        <th>#</th>
        <th>CPF</th>
        <th>CNS</th>
        <th>Nome</th>
        <th>Mae</th>
        <th>DtNascimento</th>
        <th>Idade</th>
        <th>MA</th>
        <th>INE</th>
        <th>CNES</th>
        <th>Hiper</th>
        <th>Diabe</th>
        <th>A/C</th>
        <th>Gest</th>
        <th>Sexo</th>
        <th>Estado</th>
    </tr>
</thead>
<tbody>
";

$dti = 0;
$dtf = 0;

$cidsH = array("I10","I11","I110","I119","I12","I120","I129","I13","I130","I131","I132","I139","I15","I150","I151","I152","I158","I159","I270","I272","O10","O100","O101","O102","O103","O104","O109","O11"); // O12, O13, O14, O16
$ciapsH = array("K86","K87","ABP005"); // W81
$cbosH = array("2251","2252","2253","2231","2235");

$cidsD = array("E10","E100","E101","E102","E103","E104","E105","E106","E107","E108","E109","E11","E110","E111","E112","E113","E114","E115","E116","E117","E118","E119","E12","E120","E121","E122","E123","E124","E125","E126","E127","E128","E129","E13","E130","E131","E132","E133","E134","E135","E136","E137","E138","E139","E14","E140","E141","E142","E143","E144","E145","E146","E147","E148","E149","O240","O241","O242","O243","P702"); // O244, O249
$ciapsD = array("T89","T90","ABP006"); // W85
$cbosD = array("2251","2252","2253","2231","2235");

// ------ IDADE -----------------------------------------------------
$idin = 0;
$idfi = 150;
$idss = explode(":",$filtro);
if ($opcao == '11'){
    $idin = $idss[0];
    $idfi = $idss[0];
} else {
    if (count($idss) > 1){
        if ($opcao == '12' || $opcao == '13'){
            $idin = $idss[0];
            $idfi = $idss[1];
        }
    }
}
$idinn = $idin*12;
$idfin = $idfi*12+11;
// ------ SEXO ------------------------------------------------------
$sexo = 'T';
if ($opcao == '12'){
    $sexo = "FEMININO";
} elseif ($opcao == '13'){
    $sexo = "MASCULINO";
}
$contador = 0;
$ctrl_duplicado = array();
$cids = new Cidadaos($cdb, $sexo, $idinn, $idfin, $dti, $dtf);
$cids->todos();
if ($cids->totalEncontrado > 0){
    for ($i=0;$i<count($cids->cidadaos);$i++){

        $cid_cidadao = $cids->cidadaos[$i]['cidadao'];
        $cid_cidadaoc = $cids->cidadaos[$i]['cidadaoc'];
        $cid_cidadao2 = $cids->cidadaos[$i]['cidadao2'];
        if ($cid_cidadao2 == null || strlen(trim($cid_cidadao2)) <= 0){
            $cid_cidadao2 = 0;
        }
        if (strlen($cid_cidadao) <= 0 && $cid_cidadao2 > 0){
            $cid_cidadao = $cid_cidadao2;
        }
        $cid = new CidadaoFAT($cdb, $cid_cidadao);
        $cid->dados();

        // BAIXADO +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        $cid_baixado = 0;
        if (substr($cid->motBaixaDs,0,1) != 'N'){
            if (substr($cid->motBaixaDs,0,1) == 'M'){
                $cid_baixado = 1;
            } else {
                if (substr($cid->motBaixaDs,1,1) == 'b'){
                    $cid_baixado = 2;
                }
            }
        }
        $data_obito = "";
        if (strlen($data_obito) >= 8){
            $data_obito = datanas2($cid->dtObito);
            $cid_baixado = 2;
        }
        if ($cid->faleceu == 1){
            $cid_baixado = 2;
        }
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        $idade = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),$dtf);
        $idade_hoje = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),date('Ymd'));
        $pec_cid_cpf = (strlen($cids->cidadaos[$i]['cpf']) != 11) ? 'CPF' : $cids->cidadaos[$i]['cpf'];
        $pec_cid_cns = (strlen($cids->cidadaos[$i]['cns']) != 15) ? 'CNS' : $cids->cidadaos[$i]['cns'];
        $pec_cid_nome = $cids->cidadaos[$i]['nome'];
        $pec_cid_mae = $cids->cidadaos[$i]['mae'];
        $pec_cid_dtnas = datanas2($cids->cidadaos[$i]['dtNascimento']);
        $pec_cid_ine = $cid->ine;
        $pec_cid_cnes = $cid->cnes;
        $pec_cid_ma = $cid->ma;

        $data_inicial_clinico = datanas3($cids->cidadaos[$i]['dtNascimento']);

        $stGestante = ($cid->stGestante == 1) ? "<span class=\"badge bg-warning\">Sim</span>" : 'Não';
        $stHipertensao = ($cid->stHipertensao == 1) ? "<span class=\"badge bg-warning\">Sim</span>" : 'Não';
        $stDiabete = ($cid->stDiabete == 1) ? "<span class=\"badge bg-warning\">Sim</span>" : 'Não';
        $stHiperAC = ($cid->stHipertensao == 1) ? 'A/-' : '-/-';
        $stDiabeAC = ($cid->stDiabete == 1) ? 'A/-' : '-/-';

        if (strlen($data_inicial_clinico) != 8){
            $data_inicial_clinico = 19600101;
        }
        if ($cid_cidadao > 0){
            $cliH = new ClinicoFAT($cdb, $cid_cidadao, $cidsH, $ciapsH, $cbosH, $data_inicial_clinico, date('Ymd'));
            if ($cliH->ok){
                $stHiperAC = substr($stHiperAC,0,2)."C";
                $stHipertensao = "<span class=\"badge bg-warning\">Sim</span>";
            }
            $cliD = new ClinicoFAT($cdb, $cid_cidadao, $cidsD, $ciapsD, $cbosD, $data_inicial_clinico, date('Ymd'));
            if ($cliD->ok){
                $stDiabeAC = substr($stDiabeAC,0,2)."C";
                $stDiabete = "<span class=\"badge bg-warning\">Sim</span>";
            }
        }

        $ctrl = $pec_cid_cpf.$pec_cid_cns.$pec_cid_nome.$pec_cid_mae;

        if ($scsus_demo){
            $pec_cid_cpf = "***.***.***-**";
            $pec_cid_cns = "***************";
            $pec_cid_nome = "********** ********* ***********";
            $pec_cid_mae = "******* ********** ************";
            $pec_cid_dtnas = "**/**/****";
            $pec_cid_ine = "0000******";
            $pec_cid_cnes = "*******";
        }

        $mostrar = false;
        if ($opcao == '01'){
            // óbitos OK
            if ($cid_baixado == 2){
                $mostrar = true;
            }
        } elseif ($opcao == '02'){
            // mudança de território OK
            if ($cid_baixado == 1){
                $mostrar = true;
            }
        } elseif ($opcao == '03'){
            // sem equipe OK
            if (strlen($cid->ine) < 5){
                $mostrar = true;
            }
        } elseif ($opcao == '04'){
            // sem ma OK
            if (strlen($cid->ma) <= 0 || $cid->ma == null || $cid->ma == '' || $cid->ma == 'FA' || $cid->ma == '0' || $cid->ma == '00'){
                $mostrar = true;
                $pec_cid_ma = "<span class=\"badge bg-info\">FA</span>";
            }
        } elseif ($opcao == '05'){
            // ma ??? OK
            if ($cid->ma == $filtro){
                $mostrar = true;
            }
        } elseif ($opcao == '06'){
            // cnes ??? OK
            if ($cid->cnes == $filtro){
                $mostrar = true;
            }
        } elseif ($opcao == '07'){
            // ine ??? OK
            if ($cid->ine == $filtro){
                $mostrar = true;
            }
        } elseif ($opcao == '08'){
            // hiper
        } elseif ($opcao == '09'){
            // diab
        } elseif ($opcao == '10'){
            // gest
        } elseif ($opcao == '11'){
            // idade ??? OK
            $mostrar = true;
        } elseif ($opcao == '12'){
            // mulher idade ??? OK
            $mostrar = true;
        } elseif ($opcao == '13'){
            // homem idade ??? OK
            $mostrar = true;
        }
        if (strlen($cid->ine) < 5){
            $pec_cid_ine = "<span class=\"badge bg-info\">SEM EQUIPE</span>";
        }
        $situacao = "<span class=\"badge bg-success\">Ativo</span>";
        if ($cid_baixado > 0){
            $situacao = "<span class=\"badge bg-danger\">Baixado</span>";
            if ($cid_baixado == 1){
                $situacao = "<span class=\"badge bg-danger\">Baixado</span> (Óbito ".$data_obito.")";
            }
            if ($cid_baixado == 2){
                $situacao = "<span class=\"badge bg-danger\">Baixado</span> (Mudança de território)";
            }
        }

        if ($mostrar){
            $contador++;
                echo "<tr>";
                    echo "<td>".$contador."</td>";
                    echo "<td>".$pec_cid_cpf."</td>";
                    echo "<td>".$pec_cid_cns."</td>";
                    echo "<td>".$pec_cid_nome."</td>";
                    echo "<td>".$pec_cid_mae."</td>";
                    echo "<td>".$pec_cid_dtnas."</td>";
                    echo "<td>".$idade."</td>";
                    echo "<td>".$pec_cid_ma."</td>";
                    echo "<td>".$pec_cid_ine."</td>";
                    echo "<td>".$pec_cid_cnes."</td>";
                    echo "<td>".$stHipertensao."</td>";
                    echo "<td>".$stDiabete."</td>";
                    echo "<td>".$stHiperAC."|".$stDiabeAC."</td>";
                    echo "<td>".$stGestante."</td>";
                    echo "<td>".$cid->sexo1."</td>";
                    echo "<td>".$situacao."</td>";
                echo "</tr>";
        }
    }
}

?>
<script>
    SlickLoader.disable();
    $(document).ready(function() {
        $('#tbdt').DataTable({
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            },
            dom: 'Bfrtip',
            buttons: [
                'excelHtml5',
                'csvHtml5'
            ]
        });
    });
</script>