<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Vacinas</h4>
                </div>
                <div class="card-body mt-2">
<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$f_calibra = "calibracao.php";
if (file_exists($f_calibra)){
    include $f_calibra;
}

$dti = fgpa('i');
$dtf = fgpa('f');
$idin = 0;
$idfi = 150;
$imunos = '';
$dose = '';
$sexo = 'A';
$cpf = '';
$cns = '';
$metodo = 1;
$sexo_moh = "T";

$rs = $con->prepare("SELECT * FROM cidadao_tb_cf_vacinas WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$dti = $row->dti;
			$dtf = $row->dtf;
            $idin = $row->idin;
            $idfi = $row->idfi;
            $cpf = $row->cpf;
            $cns = $row->cns;
            $imunos = $row->imunos;
            $dose = $row->dose;
            $sexo = $row->sexo;
            $metodo = $row->metodo;
		}
	}
}

$sexo_m = $sexo;
if ($sexo_m == 'A'){
    $sexo_m = "Ambos";
}
$metodo_m = $metodo;
if ($metodo_m == '1'){
    $metodo_m = "Apenas quem atende aos critérios";
} else {
    $metodo_m = "Todos";
}
echo "
                    <p class=\"card-text\">
                        Data inicial: ".datanas6($dti)." | Data final: ".datanas6($dtf)."<br>
                        Idade inicial: ".$idin." | Idade final: ".$idfi."<br>
                        CPF: ".$cpf."<br>
                        CNS: ".$cns."<br>
                        Sexo: ".$sexo_m."<br>
                        Dose: ".$dose."<br>
                        Método: ".$metodo_m."<br>
                        Imunobiológicos: ".$imunos."<br>
                        Gerado em: ".date('d/m/Y H:i:s')."
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
";

// --------------------------------------------------------
$ar_imunos = explode(";",$imunos);
$vr_imunos = false;
if (count($ar_imunos) == 1){
    if (strlen($ar_imunos[0]) > 0){
        $vr_imunos = true;
    }
} elseif (count($ar_imunos) > 1){
    $vr_imunos = true;
}
$w_imunos = "";
if ($vr_imunos){
    $w_imunos = "and ds_filtro_imunobiologico LIKE ANY (array[";
    foreach ($ar_imunos as $v) {
        $w_imunos .= "'%|".$v."|%',";
    }
    $w_imunos = substr($w_imunos,0,-1);
    $w_imunos .= "])";
}
// --------------------------------------------------------
$ar_cpf = explode(";",$cpf);
$vr_cpf = false;
if (count($ar_cpf) == 1){
    if (strlen($ar_cpf[0]) > 0){
        $vr_cpf = true;
    }
} elseif (count($ar_cpf) > 1){
    $vr_cpf = true;
}
$w_cpf = "";
if ($vr_cpf){
    $w_cpf = "nu_cpf_cidadao LIKE ANY (array[";
    foreach ($ar_cpf as $v) {
        $w_cpf .= "'".$v."',";
    }
    $w_cpf = substr($w_cpf,0,-1);
    $w_cpf .= "])";
}
// --------------------------------------------------------
$ar_cns = explode(";",$cns);
$vr_cns = false;
if (count($ar_cns) == 1){
    if (strlen($ar_cns[0]) > 0){
        $vr_cns = true;
    }
} elseif (count($ar_cns) > 1){
    $vr_cns = true;
}
$w_cns = "";
if ($vr_cns){
    $w_cns = "nu_cns LIKE ANY (array[";
    foreach ($ar_cns as $v) {
        $w_cns .= "'".$v."',";
    }
    $w_cns = substr($w_cns,0,-1);
    $w_cns .= "])";
}
// --------------------------------------------------------
$w_cpf_cns = "";
if (strlen($w_cpf) > 0){
    $w_cpf_cns = "and ".$w_cpf;
    if (strlen($w_cns) > 0){
        $w_cpf_cns = "and (".$w_cpf_cns." or ".$w_cns.")";
    }
} else {
    if (strlen($w_cns) > 0){
        $w_cpf_cns = "and ".$w_cns;
    }
}
// --------------------------------------------------------
$w_dtnas = "";
if (strlen($idfi) > 0 && strlen($idfi) > 0){
    if ($idfi > $idin){
        $data_atual = date('Ymd');
        $dia_atual = substr($data_atual,6,2);
        $mes_atual = substr($data_atual,4,2);
        $ano_atual = (int) substr($data_atual,0,4);
        $adi = $ano_atual - $idfi - 1;
        $adf = $ano_atual - $idin;
        $dt1 = $adi.'-'.$mes_atual.'-'.$dia_atual;
        $dt2 = $adf.'-'.$mes_atual.'-'.$dia_atual;
        $w_dtnas = "and (dt_nascimento > '".$dt1."' and dt_nascimento <= '".$dt2."')";
    }
}
// --------------------------------------------------------
$ar_doses = explode(";",$dose);
$vr_doses = false;
if (count($ar_doses) == 1){
    if (strlen($ar_doses[0]) > 0){
        $vr_doses = true;
    }
} elseif (count($ar_doses) > 1){
    $vr_doses = true;
}
$w_doses = "";
if ($vr_doses){
    $w_doses = "and ds_filtro_dose_imunobiologico LIKE ANY (array[";
    foreach ($ar_doses as $v) {
        $w_doses .= "'%|".$v."|%',";
    }
    $w_doses = substr($w_doses,0,-1);
    $w_doses .= "])";
}
// --------------------------------------------------------
$w_sexo = "";
if ($sexo == 'M'){
    $w_sexo = "where sg_sexo = 'M'";
    $sexo_moh = "MASCULINO";
} elseif ($sexo == 'F'){
    $w_sexo = "where sg_sexo = 'F'";
    $sexo_moh = "FEMININO";
}
// --------------------------------------------------------

include($path_local_raiz.'class/_cidadao.class.php');
include($path_local_raiz.'class/_vacinas.class.php');

if ($metodo == 9){
    /*
    co_seq_fat_vacinacao
    co_dim_tipo_ficha
    co_dim_municipio
    co_dim_profissional
    co_dim_cbo
    co_dim_unidade_saude
    co_dim_equipe
    co_dim_tempo
    co_dim_faixa_etaria
    nu_uuid_ficha
    co_dim_turno
    nu_atendimento
    nu_prontuario
    nu_cns
    dt_nascimento
    co_dim_sexo
    co_dim_local_atendimento
    co_dim_tipo_origem_dado_transp
    st_viajante
    st_comunicante_hanseniase
    st_gestante
    st_puerpera
    ds_filtro_imunobiologico
    ds_filtro_estrategia_vacinacao
    ds_filtro_dose_imunobiologico
    ds_filtro_lote
    ds_filtro_fabricante
    nu_uuid_dado_transp
    co_dim_cds_tipo_origem
    co_fat_cidadao_pec
    dt_inicial_atendimento
    dt_final_atendimento
    nu_cpf_cidadao
    ds_filtro_grupo_atendimento
    nu_cnes
    no_unidade_saude
    nu_ine
    no_equipe
    nu_cns_profissional
    no_profissional
    nu_cbo
    no_cbo
    co_cidadao
    ds_sexo
    sg_sexo
    */
    $sql = "
    select
        t6.*,
        tb_dim_sexo.ds_sexo,
        tb_dim_sexo.sg_sexo
    from
    (
        select
            t5.*,
            tb_fat_cidadao_pec.co_cidadao
        from
        (
            select
                t4.*,
                tb_dim_cbo.nu_cbo,
                tb_dim_cbo.no_cbo
            from
            (
                select
                    t3.*,
                    tb_dim_profissional.nu_cns as nu_cns_profissional,
                    tb_dim_profissional.no_profissional
                from
                (
                    select
                        t2.*,
                        tb_dim_equipe.nu_ine,
                        tb_dim_equipe.no_equipe
                    from
                    (
                        select
                            t1.*,
                            tb_dim_unidade_saude.nu_cnes,
                            tb_dim_unidade_saude.no_unidade_saude
                        from
                        (
                            select
                                *
                            from 
                                tb_fat_vacinacao
                            where
                                (co_dim_tempo >= ".$dti." and co_dim_tempo <= ".$dtf.")
                                ".$w_cpf_cns."
                                ".$w_imunos."
                                ".$w_dtnas."
                                ".$w_doses."
                        ) as t1
                        left join
                            tb_dim_unidade_saude
                        on t1.co_dim_unidade_saude = tb_dim_unidade_saude.co_seq_dim_unidade_saude
                    ) as t2
                    left join
                        tb_dim_equipe
                    on t2.co_dim_equipe = tb_dim_equipe.co_seq_dim_equipe
                ) as t3
                left join
                    tb_dim_profissional
                on t3.co_dim_profissional = tb_dim_profissional.co_seq_dim_profissional
            ) as t4
            left join
                tb_dim_cbo
            on t4.co_dim_cbo = tb_dim_cbo.co_seq_dim_cbo
        ) as t5
        left join
            tb_fat_cidadao_pec
        on t5.co_fat_cidadao_pec = tb_fat_cidadao_pec.co_seq_fat_cidadao_pec
    ) as t6
    left join
        tb_dim_sexo
    on t6.co_dim_sexo = tb_dim_sexo.co_seq_dim_sexo
    ".$w_sexo."
    order by co_fat_cidadao_pec, co_dim_tempo
    ";

    echo "
        <table id=\"tbdt\" class=\"table table-striped\">
        <thead>
            <tr>
                <th>CPF</th>
                <th>CNS</th>
                <th>Nome</th>
                <th>Mae</th>
                <th>DtNascimento</th>
                <th>Idade</th>
                <th>CNS Prof.</th>
                <th>Profissional</th>
                <th>Data</th>
                <th>INE</th>
                <th>CNES</th>
                <th>Imunos</th>
                <th>Doses</th>
            </tr>
        </thead>
        <tbody>
    ";

    $rs = $cdb->prepare($sql);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $pec_cidadao = trim($row->co_cidadao);
                $pec_cns = trim($row->nu_cns);
                $pec_cpf = trim($row->nu_cpf_cidadao);
                $cid = new Cidadao($cdb, $pec_cns, $pec_cpf, null, null, '', '', '');
                $cid->dados();
                // ...........................................................................................................
                $vac_imunos = str_replace(" ","",substr(substr($row->ds_filtro_imunobiologico,0,-1),1));
                $vac_doses = str_replace(" ","",substr(substr($row->ds_filtro_dose_imunobiologico,0,-1),1));
                $array_imunos = explode("|",$vac_doses);
                $array_doses = explode("|",$vac_imunos);
                $encontrou_dose = false;
                if ($vr_doses){
                    foreach($array_imunos as $key=>$value) {
                        foreach($ar_imunos as $vl) {
                            if ($value == $vl){
                                foreach($ar_doses as $vd) {
                                    if ($vd == $array_doses[$key]){
                                        $encontrou_dose = true;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    $encontrou_dose = true;
                }
                // ...........................................................................................................
                if ($encontrou_dose){
                    $apenas_imunos = array_intersect($array_imunos,$ar_imunos);
                    $apenas_doses = array_intersect($array_doses,$ar_doses);
                    $show_imunos = "";
                    $show_doses = "";
                    foreach ($apenas_imunos as $key1=>$value1){
                        $show_imunos .= "(".$key1.")".$value1."|";
                    }
                    $show_imunos = substr($show_imunos,0,-1);
                    foreach ($apenas_doses as $key=>$value){
                        $show_doses .= "(".$key.")".$value."|";
                    }
                    $show_doses = substr($show_doses,0,-1);

                    $pec_cid_cpf = $cid->cpf;
                    $pec_cid_cns = $cid->cns;
                    $pec_cid_nome = trim($cid->nome);
                    $pec_cid_mae = trim($cid->mae);
                    $pec_cid_dtnas = datanas2($row->dt_nascimento);
                    $idade = idadeint(datanas3($row->dt_nascimento),date('Ymd'));
                    if (strlen($pec_cid_nome) <= 0){
                        if (strlen($pec_cidadao) > 0){
                            $cidn = new CidadaoFAT($cdb, $pec_cidadao);
                            $cidn->dados();
                            $pec_cid_cpf = $cidn->cpf;
                            $pec_cid_cns = $cidn->cns;
                            $pec_cid_nome = trim($cidn->nome);
                            $pec_cid_mae = trim($cidn->mae);
                        }
                    }
                    if (strlen($pec_cid_nome) > 0){
                        echo "<tr>";
                            echo "<td>".$pec_cid_cpf."</td>";
                            echo "<td>".$pec_cid_cns."</td>";
                            echo "<td>".$pec_cid_nome."</td>";
                            echo "<td>".$pec_cid_mae."</td>";
                            echo "<td>".$pec_cid_dtnas."</td>";
                            echo "<td>".$idade."</td>";
                            echo "<td>".$row->nu_cns_profissional."</td>";
                            echo "<td>".$row->no_profissional."</td>";
                            echo "<td>".datanas6($row->co_dim_tempo)."</td>";
                            echo "<td>".$row->nu_ine."</td>";
                            echo "<td>".$row->nu_cnes."</td>";
                            echo "<td>".$show_imunos."</td>";
                            echo "<td>".$show_doses."</td>";
                        echo "</tr>";
                    }
                }
            }
        }
    }
    echo "
        </tbody>
        </table>
    ";
} else {
    echo "
        <table id=\"tbdt\" class=\"table table-striped\">
        <thead>
            <tr>
                <th>TV</th>
                <th>CPF</th>
                <th>CNS</th>
                <th>Nome</th>
                <th>Mae</th>
                <th>DtNascimento</th>
                <th>Idade/Hoje</th>
                <th>CNS Prof.</th>
                <th>Profissional</th>
                <th>Data</th>
                <th>INE</th>
                <th>CNES</th>
                <th>Imunos</th>
                <th>Doses</th>
            </tr>
        </thead>
        <tbody>
    ";
    $ctrl_duplicado = array();
    $idinn = $idin*12;
    $idfin = $idfi*12+11;
    $cids = new Cidadaos($cdb, $sexo_moh, $idinn, $idfin, $dti, $dtf);
    $cids->todos();
    if ($cids->totalEncontrado > 0){
        for ($i=0;$i<count($cids->cidadaos);$i++){

            $pec_cid_cpf = $cids->cidadaos[$i]['cpf'];
            $pec_cid_cns = $cids->cidadaos[$i]['cns'];
            $pec_cid_nome = $cids->cidadaos[$i]['nome'];
            $pec_cid_mae = $cids->cidadaos[$i]['mae'];
            $pec_cid_dtnas = datanas2($cids->cidadaos[$i]['dtNascimento']);
            $idade = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),$dtf);
            $idade_hoje = idadeint(datanas3($cids->cidadaos[$i]['dtNascimento']),date('Ymd'));

            $ctrl = $pec_cid_cpf.$pec_cid_cns.$pec_cid_nome.$pec_cid_mae;

            $mostrar = false;
            if ($vr_cpf){
                if (in_array($pec_cid_cpf, $ar_cpf)){
                    $mostrar = true;
                }
            }
            if ($vr_cns){
                if (in_array($pec_cid_cns, $ar_cns)){
                    $mostrar = true;
                }
            }
            if (!$vr_cpf && !$vr_cns){
                $mostrar = true;
            }

            if ($scsus_demo){
                $pec_cid_cpf = "***.***.***-**";
                $pec_cid_cns = "***************";
                $pec_cid_nome = "********** ********* ***********";
                $pec_cid_mae = "******* ********** ************";
                $pec_cid_dtnas = "**/**/****";
            }

            if ($mostrar){
                if (strlen($cids->cidadaos[$i]['cidadao']) > 0){
                //if (strlen($cids->cidadaos[$i]['cidadaoc']) > 0){
                    if (isset($calibracao_vacinas)){
                        if ($calibracao_vacinas == 'C'){
                            //$vacs = new Vacinas($cdb, $cids->cidadaos[$i]['cns'], $cids->cidadaos[$i]['cpf'], '', $ar_imunos, $dti, $dtf);
                            $vacs = new VacinasFAT($cdb, $cids->cidadaos[$i]['cidadao'], array(), $ar_imunos, array(), $dti, $dtf);
                            //$vacs = new Vacinas($cdb, $cids->cidadaos[$i]['cidadaoc'], array(), $ar_imunos, $dti, $dtf);
                        } else {
                            $vacs = new VacinasFAT($cdb, $cids->cidadaos[$i]['cidadao'], array(), $ar_imunos, array(), $dti, $dtf);
                            //$vacs = new Vacinas($cdb, $cids->cidadaos[$i]['cidadaoc'], array(), $ar_imunos, $dti, $dtf);
                        }
                    } else {
                        $vacs = new VacinasFAT($cdb, $cids->cidadaos[$i]['cidadao'], array(), $ar_imunos, array(), $dti, $dtf);
                        //$vacs = new Vacinas($cdb, $cids->cidadaos[$i]['cidadaoc'], array(), $ar_imunos, $dti, $dtf);
                    }
                } else {
                    //$vacs = new Vacinas($cdb, $cids->cidadaos[$i]['cns'], $cids->cidadaos[$i]['cpf'], '', $ar_imunos, $dti, $dtf);
                    $vacs = new VacinasFAT($cdb, $cids->cidadaos[$i]['cidadao'], array(), $ar_imunos, array(), $dti, $dtf);
                    //$vacs = new Vacinas($cdb, $cids->cidadaos[$i]['cidadaoc'], array(), $ar_imunos, $dti, $dtf);
                }
                /*
                echo "<br><br><br>";
                echo $vacs->sql1."<br><br><br>";
                echo $vacs->sql2."<br><br><br>";
                */
                $vacs->todos();
                if ($vacs->totalEncontrado > 0){
                    for ($k=0;$k<count($vacs->vacinas);$k++){

                        $ctrl .= $vacs->vacinas[$k]['dtVacina'].$vacs->vacinas[$k]['imuno'].$vacs->vacinas[$k]['dose'];

                        $mostrar_det = false;
                        if ($vr_doses){
                            if (in_array($vacs->vacinas[$k]['dose'], $ar_doses)){
                                $mostrar_det = true;
                            }
                        } else {
                            $mostrar_det = true;
                        }


                        $show_vac_cnsprofissional = $vacs->vacinas[$k]['cnsProfissional'];
                        $show_vac_nomeprofissional = $vacs->vacinas[$k]['nomeProfissional'];
                        $show_vac_dtvacina = datanas6($vacs->vacinas[$k]['dtVacina']);
                        $show_vac_ine = $vacs->vacinas[$k]['ine'];
                        $show_vac_cnes = $vacs->vacinas[$k]['cnes'];
                        $show_vac_imono = $vacs->vacinas[$k]['imuno']." ".$vacs->vacinas[$k]['sgImuno'];
                        $show_vac_dose = $vacs->vacinas[$k]['dose'];
                        if ($scsus_demo){
                            $show_vac_cnsprofissional = "***************";
                            $show_vac_nomeprofissional = "******** ********* ***********";
                            $show_vac_ine = "0000******";
                            $show_vac_cnes = "******";
                        }


                        if ($mostrar_det){
                            if (!in_array($ctrl, $ctrl_duplicado)){
                                echo "<tr>";
                                    echo "<td>SIM</td>";
                                    echo "<td>".$pec_cid_cpf."</td>";
                                    echo "<td>".$pec_cid_cns."</td>";
                                    echo "<td>".$pec_cid_nome."</td>";
                                    echo "<td>".$pec_cid_mae."</td>";
                                    echo "<td>".$pec_cid_dtnas."</td>";
                                    echo "<td>".$idade."/".$idade_hoje."</td>";
                                    echo "<td>".$show_vac_cnsprofissional."</td>";
                                    echo "<td>".$show_vac_nomeprofissional."</td>";
                                    echo "<td>".$show_vac_dtvacina."</td>";
                                    echo "<td>".$show_vac_ine."</td>";
                                    echo "<td>".$show_vac_cnes."</td>";
                                    echo "<td>".$show_vac_imono."</td>"; // noImuno
                                    echo "<td>".$show_vac_dose."</td>";
                                echo "</tr>";
                                $ctrl_duplicado[] = $ctrl;
                            }
                        }

                    }
                } else {
                    if ($metodo == 2){
                        echo "<tr>";
                            echo "<td>NAO</td>";
                            echo "<td>".$pec_cid_cpf."</td>";
                            echo "<td>".$pec_cid_cns."</td>";
                            echo "<td>".$pec_cid_nome."</td>";
                            echo "<td>".$pec_cid_mae."</td>";
                            echo "<td>".$pec_cid_dtnas."</td>";
                            echo "<td>".$idade."/".$idade_hoje."</td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                            echo "<td></td>";
                        echo "</tr>";
                    }
                }
            }
        }
    }
}



?>
<script>
    SlickLoader.disable();
    $(document).ready(function() {
        $('#tbdt').DataTable({
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            },
            dom: 'Bfrtip',
            buttons: [
                'excelHtml5',
                'csvHtml5'
            ]
        });
    });
</script>