<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$tipo_municipio = '';
$homologados = '0';
$num_cons_med_esf = 0;
$num_cons_enf_esf = 0;
$num_cons_med_eap30 = 0;
$num_cons_enf_eap30 = 0;
$num_cons_med_eap20 = 0;
$num_cons_enf_eap20 = 0;

$rs = $con->prepare("SELECT * FROM infoaps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
      $tipo_municipio = $row->tipo_municipio;
      $homologados = $row->homologados;
      $num_cons_med_esf = $row->num_cons_med_esf;
      $num_cons_enf_esf = $row->num_cons_enf_esf;
      $num_cons_med_eap30 = $row->num_cons_med_eap30;
      $num_cons_enf_eap30 = $row->num_cons_enf_eap30;
      $num_cons_med_eap20 = $row->num_cons_med_eap20;
      $num_cons_enf_eap20 = $row->num_cons_enf_eap20;
		}
	}
}

$tiposm = array();
$tiposm[0][0] = 'UR'; $tiposm[0][1] = 'Urbano';
$tiposm[1][0] = 'IA'; $tiposm[1][1] = 'Intermediário adjacente';
$tiposm[2][0] = 'RA'; $tiposm[2][1] = 'Rural adjacente';
$tiposm[3][0] = 'IR'; $tiposm[3][1] = 'Intermediário remoto';
$tiposm[4][0] = 'RR'; $tiposm[4][1] = 'Rural remoto';

?>
<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Configurações do Informatiza APS</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Parâmetros globais</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                    <div class="row g-1 mb-md-1">
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">Tipologia do município</label>
                                <select class="form-select" aria-label="Default select example" name="tipo_municipio" id="tipo_municipio">
                                <?php
                                    for ($o=0;$o<count($tiposm);$o++){
                                      if ($tipo_municipio == $tiposm[$o][0]){
                                        echo "<option value=\"".$tiposm[$o][0]."\" selected>".$tiposm[$o][1]."</option>";
                                      } else {
                                        echo "<option value=\"".$tiposm[$o][0]."\">".$tiposm[$o][1]."</option>";
                                      }
                                    }
                                ?>
				                        </select>
                            </div>
                        </div>

                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="num_cons_med_esf">Nº de consultas médicas mensais ESF</label>
				                    <input type="text" class="form-control" name="num_cons_med_esf" id="num_cons_med_esf" value="<?php echo $num_cons_med_esf;?>">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="num_cons_enf_esf">Nº de consultas de enfermagem mensais ESF</label>
                            <input type="text" class="form-control" name="num_cons_enf_esf" id="num_cons_enf_esf" value="<?php echo $num_cons_enf_esf;?>" />
                        </div>

                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="num_cons_med_eap30">Nº de consultas médicas mensais EAP (30 hrs)</label>
				                    <input type="text" class="form-control" name="num_cons_med_eap30" id="num_cons_med_eap30" value="<?php echo $num_cons_med_eap30;?>">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="num_cons_enf_eap30">Nº de consultas de enfermagem mensais EAP (30 hrs)</label>
                            <input type="text" class="form-control" name="num_cons_enf_eap30" id="num_cons_enf_eap30" value="<?php echo $num_cons_enf_eap30;?>" />
                        </div>

                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="num_cons_med_eap20">Nº de consultas médicas mensais EAP (20 hrs)</label>
				                    <input type="text" class="form-control" name="num_cons_med_eap20" id="num_cons_med_eap20" value="<?php echo $num_cons_med_eap20;?>">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="num_cons_enf_eap20">Nº de consultas de enfermagem mensais EAP (20 hrs)</label>
                            <input type="text" class="form-control" name="num_cons_enf_eap20" id="num_cons_enf_eap20" value="<?php echo $num_cons_enf_eap20;?>" />
                        </div>

                        <div class="col-xl-8 col-md-8 col-12">
                            <label class="form-label" for="homologados">Homologados (0 = todas)</label>
                            <input type="text" class="form-control" name="homologados" id="homologados" value="<?php echo $homologados;?>" /><br>
                        </div>



                        <button type="submit" class="btn btn-primary" id="button-addon2">Gravar e gerar</button>
                    </div>

                  </form>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
include('info.php');
if (isset($mod_serv_video_1)){
  if (strlen($mod_serv_video_1) > 0){
    echo "<a href=\"".$mod_serv_video_1."\" target=\"_blank\"><i class=\"fa fa-film text-danger\"></i></a> Vídeo<br>";
  }
}
if (file_exists('leiame.txt')){
  echo "<a href=\"mod/infoaps/leiame.txt\" target=\"_blank\"><i class=\"fa fa-info-circle text-primary\"></i></a> Leia-me para mais informações<br>";
}
echo "<br>";
?>
<script>
$(function () {
  $('#frm').validate({
    submitHandler: function (form) {

        $.post('mod/infoaps/gv_cf.php', $('#frm').serialize(), function (data, textStatus) {
          if (data == 'Ok'){ // data.substring(0,2)
            swal.fire('Ok!','Gravado com sucesso!','success');
          } else {
            swal.fire('erro!',data,'error');
          }
        });
    },
    rules: {
        num_cons_med_esf: {
          required: true,
          number:true
        },
        num_cons_enf_esf: {
          required: true,
          number:true
        },
        num_cons_med_eap30: {
          required: true,
          number:true
        },
        num_cons_enf_eap30: {
          required: true,
          number:true
        },
        num_cons_med_eap20: {
          required: true,
          number:true
        },
        num_cons_enf_eap20: {
          required: true,
          number:true
        }
    },
    messages: {
        num_cons_med_esf: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        num_cons_enf_esf: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        num_cons_med_eap30: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        num_cons_enf_eap30: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        num_cons_med_eap20: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        num_cons_enf_eap20: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        }
    }
  });
})
</script>