<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$municipios = array();
if ($handle = opendir($path_local_raiz.'key/')) {
	while (false !== ($entry = readdir($handle))) {
		if ($entry != "." && $entry != "..") {
			if (strpos($entry,'rss') === false) {
				//
			} else {
                if (strlen($entry) == 11){
                    $municipios[] = substr($entry,0,7);
                }
			}
		}
	}
	closedir($handle);
}
$totalm = count($municipios);

$cidade = "<option value=\"ALL\" selected>Todos</option>";
if ($totalm > 0){
    for($i=0;$i<$totalm;$i++){
        $sql = "
            SELECT
                t1.nome AS municipio,
                t1.ibge,
                sc_tb_apoio_estados.nome AS estado,
                sc_tb_apoio_estados.uf
            FROM
            (
                SELECT
                    *
                FROM 
                    sc_tb_apoio_cidades 
                WHERE 
                    ibge = '".$municipios[$i]."'
            ) AS t1
            JOIN
                sc_tb_apoio_estados
            ON t1.id_estado = sc_tb_apoio_estados.id
        ";
        $rs = $con->query($sql);
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $cidade .= "<option value=\"".$municipios[$i]."\">".$row->ibge." [".$row->uf."] ".$row->municipio."</option>";
            }
        }
    }
}

?>

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Limpar dados</h4>
                </div>
                <div class="card-body mt-2">
                    <div class="row g-1 mb-md-1">
                        <div class="col-xl-3 col-md-3 col-12">
                            <div class="mb-1">

                            <label class="form-label" for="tempo">Data</label>
                            <input type="text" class="form-control flatpickr-basic" name="tempo" id="tempo" value="<?php echo date('d/m/Y');?>" />


                            </div>
                        </div>
                        <div class="col-xl-3 col-md-3 col-12">
                            <div class="mb-1">
                            <label class="form-label" for="ibge">IBGE</label>
                            <select class="form-select" id="ibge" name="ibge">
                                <?php
                                    echo $cidade;
                                ?>
                            </select>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-3 col-12">
                            <div class="mb-1">
                            <label class="form-label" for="cnes">CNES</label>
                            <select class="form-select" id="cnes" name="cnes">
                                <option value="ALL" selected>Todos</option>
                                <?php
                                    $rs = $cdb->query("SELECT nu_cnes, no_unidade_saude FROM tb_unidade_saude ORDER BY no_unidade_saude");
                                    if($rs->rowCount() > 0){
                                        while($row = $rs->fetch(PDO::FETCH_OBJ)){
                                            echo "<option value=\"".$row->nu_cnes."\">[".$row->nu_cnes."] ".$row->no_unidade_saude."</option>";
                                        }
                                    }
                                    $rs = $con->query("SHOW TABLES LIKE 'bpa_tb_cnes'");
                                    if($rs->execute()){
                                        if($rs->rowCount() > 0){
                                            $rsx = $con->query("SELECT * FROM bpa_tb_cnes WHERE ibge = '".$_SESSION['ibge']."' ORDER BY nomef");
                                            if($rsx->execute()){
                                                if($rsx->rowCount() > 0){
                                                    while($rowx = $rsx->fetch(PDO::FETCH_OBJ)){
                                                        echo "<option value=\"".$rowx->cnes."\">[".$rowx->cnes."] ".$rowx->nomef."</option>";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ?>
                            </select>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-3 col-12">
                            <div class="mb-1">
                            <label class="form-label" for="opcao">Opções</label>
                            <select class="form-select" id="opcao" name="opcao">
                                <option value="C">Considerar apenas CNES</option>
                                <option value="B">Considerar apenas IBGE</option>
                                <option value="D">Considerar apenas Data</option>
                                <option value="X">Considerar Data, IBGE e CNES</option>
                                <option value="T">Truncate</option>
                            </select>
                            </div>
                        </div>

                        <button type="button" class="btn btn-danger" id="reset">Limpar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Basic Inputs end -->

<script src="app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js"></script>
<script src="app-assets/js/scripts/forms/pickers/form-pickers.js"></script>

<script>
$(function () {

    $("#reset").click(function() {
        var ib = $("#ibge").find(":selected").val();
        var cnes = $("#cnes").find(":selected").val();
        var ac = $("#opcao").find(":selected").val();
        var d = $("#tempo").val();
        d = d.substring(6, 10) + d.substring(3, 5) + d.substring(0, 2);
        fazer = false;
        if (ac == 'C'){
            if (cnes == 'ALL'){
                Swal.fire(
                    'CNES',
                    'É necessário informar um CNES',
                    'error'
                );
            } else {
                fazer = true;
            }
        }
        if (ac == 'B'){
            if (ib == 'ALL'){
                Swal.fire(
                    'IBGE',
                    'É necessário informar um IBGE',
                    'error'
                );
            } else {
                fazer = true;
            }
        }
        if (ac == 'D' || ac == 'T'){
            fazer = true;
        }
        if (ac == 'X'){
            if (ib == 'ALL'){
                Swal.fire(
                    'IBGE',
                    'É necessário informar um IBGE',
                    'error'
                );
            } else {
                if (cnes == 'ALL'){
                    Swal.fire(
                        'CNES',
                        'É necessário informar um CNES',
                        'error'
                    );
                } else {
                    fazer = true;
                }
            }
        }
        if (fazer){
            $.get("mod/painel/reset.php?ac=" + ac + "&d=" + d + "&ib=" + ib + "&cnes=" + cnes, function(responseTxt, statusTxt, xhr){ 
                if(statusTxt == "success"){
                    if (responseTxt.trim().substring(0,2) == 'Ok'){
                        swal.fire('Ok!','Resetado!<br>'+responseTxt,'success');
                    } else {
                        swal.fire('erro!',responseTxt,'error');
                    }
                }
            });
        }
    });

})
</script>