<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
$d = isset($_GET["d"]) ? $_GET["d"] : date('Ymd');
$dc = datanas7($d);

$cnes = '';
$rs = $con->prepare("SELECT * FROM sc_tb_usuarios WHERE login = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
            $cnes = $row->cnes;
        }
    }
}

?>
<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Painel de inclusão na lista de chamada (manualmente / não via e-SUS)</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Inserir cidadão</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                  <input type="hidden" id="d" name="d" value="<?php echo $d;?>">
                  <input type="hidden" id="cnes" name="cnes" value="<?php echo $cnes;?>">
                    <div class="row g-1 mb-md-1">
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="cidadao">Nome cidadão</label>
                            <input type="text" class="form-control" name="cidadao" id="cidadao" value="" />
                        </div>
                        <div class="col-xl-2 col-md-2 col-12">
                            <label class="form-label" for="dt_nascimento">Data nas.</label>
                            <input type="text" class="form-control" name="dt_nascimento" id="dt_nascimento" value="" data-inputmask='"mask": "99/99/9999"' data-mask />
                        </div>
                        <div class="col-xl-2 col-md-2 col-12">
                            <label class="form-label" for="cpf">CPF</label>
                            <input type="text" class="form-control" name="cpf" id="cpf" value="" data-inputmask='"mask": "999.999.999-99"' data-mask />
                        </div>
                        <div class="col-xl-2 col-md-2 col-12">
                            <label class="form-label" for="cns">CNS</label>
                            <input type="text" class="form-control" name="cns" id="cns" value="" data-inputmask='"mask": "999999999999999"' data-mask />
                        </div>
                        <div class="col-xl-1 col-md-1 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="sexo">Sexo</label>
                                <select class="form-select" name="sexo" id="sexo">
                                  <option value="F" selected>F</option>
                                  <option value="M">M</option>
				                </select>
                            </div>
                        </div>
                        <div class="col-xl-9 col-md-9 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="prof_cpf">Profissional</label>
                                <select class="form-select" name="prof_cpf" id="prof_cpf">
                                <option value="" selected>Qualquer</option>
                                <?php
                                    $rsc = $con->query("SELECT * FROM painel_tb_profissionais WHERE ibge = '".$_SESSION['ibge']."' ORDER BY nome");
                                    if($rsc->execute()){
                                        if($rsc->rowCount() > 0){
                                            while($rowc = $rsc->fetch(PDO::FETCH_OBJ)){
                                                if (strlen($rowc->id) == 11){
                                                    echo "<option value=\"".$rowc->id."\">(".mcpf($rowc->id).") ".$rowc->nome."</option>";
                                                }
                                            }
                                        }
                                    }
                                ?>
				                </select>
                            </div>
                        </div>

                        <div class="col-xl-1 col-md-1 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="reset"></label>
                                <button type="button" class="btn btn-flat-danger" id="reset" name="reset">
                                    <i data-feather="trash-2" class="me-25"></i>
                                    <span>Reset painel</span>
                                </button>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary" id="button-addon2">Incluir</button>
                    </div>
                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body mt-2">
                    <div id="tbchamada"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
$(function () {
    $('[data-mask]').inputmask();
    $("#tbchamada").load('mod/painel/incluir_painel.php');

    setInterval(function () {
        $("#tbchamada").load('mod/painel/incluir_painel.php');
    }, 10000);

    $('#frm').validate({
        submitHandler: function (form) {

            var fazer = false;
            var cpf = $("#cpf").val().trim();
            cpf = cpf.replace(/-| |\.|\/|_/gi, "");
            var cns = $("#cns").val().trim();
            cns = cns.replace(/-| |\.|\/|_/gi, "");
            if (cpf.length == 11){
                if (!validaCpfCnpj($("#cpf").val().trim())) {
                    Swal.fire(
                        'Validação!',
                        'CPF Invalido!',
                        'error'
                    );
                } else {
                    fazer = true;
                }
            } else {
                if (cns.length == 15){
                    fazer = true;
                } else {
                    Swal.fire(
                        'Validação!',
                        'CPF ou CNS Invalido!',
                        'error'
                    );
                }
            }

            if (fazer){
                $.post('mod/painel/incluir_gv.php', $('#frm').serialize(), function (data, textStatus) {
                    if (data.substring(0,2) == 'Ok'){ 
                        swal.fire('Ok!','Gravado com sucesso! ' + data,'success');
                        $("#tbchamada").load('mod/painel/incluir_painel.php');
                    } else {
                        swal.fire('erro!',data,'error');
                    }
                });
            }

        },
        rules: {
            cidadao: {
                required: true
            },
            dt_nascimento: {
                required: true
            }
        },
        messages: {
            cidadao: {
                required: "Este campo é necessário"
            },
            dt_nascimento: {
                required: "Este campo é necessário"
            }
        }
    });


    $("#reset").click(function() {

        $.get("mod/painel/reset.php?ac=X&d=<?php echo $d;?>&ib=<?php echo $_SESSION['ibge'];?>&cnes=<?php echo $cnes;?>", function(responseTxt, statusTxt, xhr){ 
            if(statusTxt == "success"){
                if (responseTxt.trim().substring(0,2) == 'Ok'){
                    swal.fire('Ok!','Resetado!<br>'+responseTxt,'success');
                } else {
                    swal.fire('erro!',responseTxt,'error');
                }
            }
        });

    });



})
</script>