<?php
class Casas {
    public $ma;
	public $casas = array();
	public $ok;
	public $sql1;
    public $sql3;
    public $totalEncontrado;
	
	private $con;

    public function __construct($con, $ma) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->ma = $ma;
		$this->con = $con;

		$wma = "";
		if ((strlen($this->ma) > 0) && $this->ma != '0' && $this->ma != '00'){
			$wma = "WHERE nu_micro_area = '".$this->ma."'";
		}

		$this->sql1 = "
            -- tabelas com coordenadas
            -- tb_cds_domicilio (para arrumar as coordenadas dessa tabela é necessário usar o campo co_seq_cds_domicilio)
            -- tb_fat_cad_domiciliar (para arrumar as coordenadas dessa tabela é necessário usar o campo co_seq_fat_cad_domiciliar) endereco cripto
            -- tb_cds_cad_domiciliar (para arrumar as coordenadas dessa tabela é necessário usar o campo co_unico_domicilio)
            -- tb_fat_visita_domiciliar (para arrumar as coordenadas dessa tabela é necessário usar o campo co_fat_cidadao_pec)
            -- tb_cds_visita_domiciliar
            SELECT
                tc.co_seq_fat_cad_domiciliar,
                -- tb_fat_cad_domiciliar
                -- tb_fat_familia (co_fat_cad_domiciliar)
                -- tb_fat_familia_territorio (co_fat_cad_domiciliar)
                tc.co_seq_fat_cad_dom_familia,
                -- tb_fat_cad_dom_familia
                -- tb_fat_familia (co_fat_cad_dom_familia)
                tc.co_seq_familia,
                -- tb_familia
                tc.co_seq_cds_domicilio,
                -- tb_cds_domicilio
                -- tb_familia (co_cds_domicilio)
                tc.co_fat_cidadao_pec,
                -- tb_fat_cad_dom_familia
                -- tb_fat_cad_individual
                -- tb_fat_cidadao_territorio
                -- tb_fat_familia_territorio
                -- tb_fat_visita_domiciliar
                -- tb_fat_cidadao_pec (co_seq_fat_cidadao_pec)
                tc.co_unico_domicilio,
                -- tb_cds_cad_domiciliar
                tc.nu_latitude,
                tc.nu_longitude,
                tc.nu_cns_responsavel,
                tc.nu_cpf_responsavel,
                tc.dt_nascimento,
                tc.st_recusa_cadastro,
                tc.unid_saude_nu_cnes AS nu_cnes_principal,
                CASE WHEN tc.nu_cnes IS NULL THEN tc.nu_cnes_2
                    ELSE tc.nu_cnes END
                    nu_cnes,
                tc.no_unidade_saude,
                tc.unid_saude_no_bairro,
                tc.equipe_nu_ine AS nu_ine_principal,
                CASE WHEN tc.nu_ine IS NULL THEN tc.nu_ine_2
                    ELSE tc.nu_ine END
                    nu_ine,
                tc.no_equipe,
                CASE WHEN tc.nu_micro_area IS NULL THEN tc.nu_micro_area_2
                    ELSE tc.nu_micro_area END
                    nu_micro_area,
                tc.co_dim_tempo,
                tc.st_mudou,
                tc.dt_inicio_residencia,
                tc.st_domicilio_ativo,
                tc.qt_morador,
                tc.ds_complemento,
                tc.no_logradouro,
                tc.no_bairro,
                tc.ds_cep,
                tc.nu_fone_referencia,
                tc.nu_fone_residencia,
                tc.nu_domicilio,
                tc.st_fora_area,
                tc.ds_ponto_referencia,
                tc.prof_nu_cns,
                tc.prof_no_profissional,
                tc.nu_cbo,
                tc.no_cbo,
                tc.no_tipo_logradouro,
                tc.no_uf,
                tc.sg_uf,
                tb_dim_municipio.no_municipio,
                tb_dim_municipio.co_ibge
            FROM
            (
                SELECT
                    tb.*,
                    tb_uf.no_uf,
                    tb_uf.sg_uf
                FROM
                (
                    SELECT
                        ta.*,
                        tb_tipo_logradouro.no_tipo_logradouro
                    FROM
                    (
                        SELECT
                            t9.*,
                            tb_dim_cbo.nu_cbo,
                            tb_dim_cbo.no_cbo
                        FROM
                        (
                            SELECT
                                t8.*,
                                tb_dim_equipe.nu_ine AS equipe_nu_ine,
                                tb_dim_equipe.no_equipe
                            FROM
                            (
                                SELECT
                                    t7.*,
                                    tb_dim_unidade_saude.nu_cnes AS unid_saude_nu_cnes,
                                    tb_dim_unidade_saude.no_unidade_saude,
                                    tb_dim_unidade_saude.no_bairro AS unid_saude_no_bairro
                                FROM
                                (
                                    SELECT
                                        t6.*,
                                        tb_dim_profissional.nu_cns AS prof_nu_cns,
                                        tb_dim_profissional.no_profissional AS prof_no_profissional
                                    FROM
                                    (
                                        SELECT
                                            t5.co_seq_fat_cad_domiciliar,
                                            t5.co_seq_fat_cad_dom_familia,
                                            t5.co_seq_familia,
                                            tb_cds_domicilio.co_seq_cds_domicilio,
                                            tb_cds_domicilio.co_unico_domicilio,
                                            CASE WHEN t5.st_recusa_cadastro IS NULL THEN t5.st_recusa_cadastro_2
                                                ELSE t5.st_recusa_cadastro END
                                                st_recusa_cadastro,
                                            CASE WHEN t5.co_dim_profissional IS NULL THEN t5.co_dim_profissional_2
                                                ELSE t5.co_dim_profissional END
                                                co_dim_profissional,
                                            CASE WHEN t5.co_dim_unidade_saude IS NULL THEN t5.co_dim_unidade_saude_2
                                                ELSE t5.co_dim_unidade_saude END
                                                co_dim_unidade_saude,
                                            t5.nu_cnes,
                                            tb_cds_domicilio.nu_cnes AS nu_cnes_2,
                                            CASE WHEN t5.co_dim_equipe IS NULL THEN t5.co_dim_equipe_2
                                                ELSE t5.co_dim_equipe END
                                                co_dim_equipe,
                                            t5.nu_ine,
                                            tb_cds_domicilio.nu_ine AS nu_ine_2,
                                            CASE WHEN t5.co_dim_tempo IS NULL THEN t5.co_dim_tempo_2
                                                ELSE t5.co_dim_tempo END
                                                co_dim_tempo,
                                            t5.co_dim_tipo_logradouro,
                                            CASE WHEN t5.nu_micro_area IS NULL THEN t5.nu_micro_area_2
                                                ELSE t5.nu_micro_area END
                                                nu_micro_area,
                                            tb_cds_domicilio.nu_micro_area AS nu_micro_area_2,
                                            t5.co_dim_cbo,
                                            t5.co_dim_municipio,
                                            CASE WHEN t5.nu_latitude IS NULL THEN tb_cds_domicilio.nu_latitude
                                                ELSE t5.nu_latitude END
                                                nu_latitude,
                                            CASE WHEN t5.nu_longitude IS NULL THEN tb_cds_domicilio.nu_longitude
                                                ELSE t5.nu_longitude END
                                                nu_longitude,
                                            t5.nu_cns_responsavel,
                                            t5.nu_cpf_responsavel,
                                            t5.st_mudou,
                                            t5.co_fat_cidadao_pec,
                                            CASE WHEN t5.dt_nascimento IS NULL THEN t5.dt_nascimento_responsavel
                                                ELSE t5.dt_nascimento END
                                                dt_nascimento,
                                            CASE WHEN t5.dt_inicio_residencia IS NULL THEN t5.dt_reside_desde
                                                ELSE t5.dt_inicio_residencia END
                                                dt_inicio_residencia,
                                            t5.st_domicilio_ativo,
                                            CASE WHEN t5.qt_morador_3 IS NULL THEN t5.qt_morador_4
                                                ELSE t5.qt_morador_3 END
                                                qt_morador,
                                            tb_cds_domicilio.tp_logradouro,
                                            tb_cds_domicilio.ds_complemento,
                                            tb_cds_domicilio.co_municipio,
                                            tb_cds_domicilio.no_logradouro,
                                            tb_cds_domicilio.no_bairro,
                                            tb_cds_domicilio.ds_cep,
                                            tb_cds_domicilio.nu_fone_referencia,
                                            tb_cds_domicilio.nu_fone_residencia,
                                            tb_cds_domicilio.nu_domicilio,
                                            tb_cds_domicilio.co_uf,
                                            tb_cds_domicilio.st_fora_area,
                                            tb_cds_domicilio.ds_ponto_referencia
                                        FROM
                                        (
                                            SELECT 
                                                DISTINCT ON (co_cds_domicilio)
                                                *
                                            FROM
                                            (
                                                SELECT
                                                    t3.*,
                                                    tb_familia.co_seq_familia,
                                                    tb_familia.dt_nascimento_responsavel,
                                                    tb_familia.dt_reside_desde,
                                                    tb_familia.st_domicilio_ativo,
                                                    tb_familia.nu_cnes,
                                                    tb_familia.co_cds_domicilio,
                                                    tb_familia.nu_ine,
                                                    CASE WHEN t3.qt_morador_0 IS NULL THEN t3.qt_morador_1
                                                        ELSE t3.qt_morador_0 END
                                                        qt_morador_3,
                                                    tb_familia.qt_membro AS qt_morador_4
                                                FROM
                                                (
                                                    SELECT
                                                        *
                                                    FROM
                                                    (
                                                        SELECT
                                                            t1.*,
                                                            tb_fat_cad_dom_familia.co_seq_fat_cad_dom_familia,
                                                            tb_fat_cad_dom_familia.st_recusa_cadastro AS st_recusa_cadastro_2,
                                                            tb_fat_cad_dom_familia.co_dim_profissional AS co_dim_profissional_2,
                                                            tb_fat_cad_dom_familia.co_dim_unidade_saude AS co_dim_unidade_saude_2,
                                                            tb_fat_cad_dom_familia.co_dim_equipe AS co_dim_equipe_2,
                                                            tb_fat_cad_dom_familia.co_dim_tempo AS co_dim_tempo_2,
                                                            tb_fat_cad_dom_familia.nu_micro_area AS nu_micro_area_2,
                                                            tb_fat_cad_dom_familia.nu_cns_responsavel,
                                                            tb_fat_cad_dom_familia.nu_cpf_responsavel,
                                                            tb_fat_cad_dom_familia.st_mudou,
                                                            tb_fat_cad_dom_familia.co_fat_cidadao_pec,
                                                            tb_fat_cad_dom_familia.dt_nascimento,
                                                            tb_fat_cad_dom_familia.dt_inicio_residencia,
                                                            tb_fat_cad_dom_familia.qt_membro_familiar AS qt_morador_1
                                                        FROM
                                                        (
                                                            SELECT 
                                                                co_seq_fat_cad_domiciliar,
                                                                qt_morador AS qt_morador_0,
                                                                st_recusa_cadastro,
                                                                co_dim_profissional,
                                                                co_dim_municipio,
                                                                co_dim_unidade_saude,
                                                                co_dim_equipe,
                                                                co_dim_tempo,
                                                                co_dim_tipo_logradouro,
                                                                co_dim_cbo,
                                                                nu_micro_area,
                                                                nu_latitude,
                                                                nu_longitude
                                                            FROM 
                                                                tb_fat_cad_domiciliar
                                                            ".$wma."
                                                        ) AS t1
                                                        JOIN tb_fat_cad_dom_familia
                                                        ON tb_fat_cad_dom_familia.co_fat_cad_domiciliar = t1.co_seq_fat_cad_domiciliar
                                                    ) AS t2
                                                    WHERE 
                                                        nu_cns_responsavel notnull OR nu_cpf_responsavel notnull
                                                ) AS t3
                                                LEFT JOIN tb_familia
                                                ON tb_familia.nu_cpf_cns_responsavel = t3.nu_cns_responsavel OR tb_familia.nu_cpf_cns_responsavel = t3.nu_cpf_responsavel
                                            ) AS t4
                                        ) AS t5
                                        JOIN tb_cds_domicilio
                                        ON tb_cds_domicilio.co_seq_cds_domicilio = t5.co_cds_domicilio
                                    ) AS t6
                                    LEFT JOIN tb_dim_profissional
                                    ON tb_dim_profissional.co_seq_dim_profissional = t6.co_dim_profissional
                                ) AS t7
                                LEFT JOIN tb_dim_unidade_saude
                                ON tb_dim_unidade_saude.co_seq_dim_unidade_saude = t7.co_dim_unidade_saude
                            ) AS t8
                            LEFT JOIN tb_dim_equipe
                            ON tb_dim_equipe.co_seq_dim_equipe = t8.co_dim_equipe
                        ) AS t9
                        LEFT JOIN tb_dim_cbo
                        ON tb_dim_cbo.co_seq_dim_cbo = t9.co_dim_cbo	
                    ) AS ta
                    LEFT JOIN tb_tipo_logradouro
                    ON tb_tipo_logradouro.co_tipo_logradouro = ta.tp_logradouro	
                ) AS tb
                LEFT JOIN tb_uf
                ON tb_uf.co_uf = tb.co_uf	
            ) AS tc
            LEFT JOIN tb_dim_municipio
            ON tb_dim_municipio.co_seq_dim_municipio = tc.co_dim_municipio
            ORDER BY sg_uf, no_municipio, nu_micro_area, no_bairro, no_logradouro, nu_domicilio
		";
        $this->sql3 = "
            SELECT 
                no_cidadao,
                dt_nascimento,
                no_mae 
            FROM 
                tb_cidadao 
            WHERE 
                nu_cns = ? OR nu_cpf = ?
            ORDER BY co_seq_cidadao DESC LIMIT 1
        ";
    }
    public function todos() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
			if($this->totalEncontrado > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
                    $this->casas[$conta_array]['co_seq_fat_cad_domiciliar'] = $rows->co_seq_fat_cad_domiciliar;
                    $this->casas[$conta_array]['co_seq_fat_cad_dom_familia'] = $rows->co_seq_fat_cad_dom_familia;
                    $this->casas[$conta_array]['co_seq_familia'] = $rows->co_seq_familia;
                    $this->casas[$conta_array]['co_seq_cds_domicilio'] = $rows->co_seq_cds_domicilio;
                    $this->casas[$conta_array]['co_fat_cidadao_pec'] = $rows->co_fat_cidadao_pec;
                    $this->casas[$conta_array]['co_unico_domicilio'] = $rows->co_unico_domicilio;
                    $this->casas[$conta_array]['nu_latitude'] = $rows->nu_latitude;
                    $this->casas[$conta_array]['nu_longitude'] = $rows->nu_longitude;
                    $this->casas[$conta_array]['nu_cns_responsavel'] = $rows->nu_cns_responsavel;
                    $this->casas[$conta_array]['nu_cpf_responsavel'] = $rows->nu_cpf_responsavel;
                    $this->casas[$conta_array]['dt_nascimento'] = $rows->dt_nascimento;
                    $this->casas[$conta_array]['st_recusa_cadastro'] = $rows->st_recusa_cadastro;
                    $this->casas[$conta_array]['nu_cnes_principal'] = $rows->nu_cnes_principal;
                    $this->casas[$conta_array]['nu_cnes'] = $rows->nu_cnes;
                    $this->casas[$conta_array]['no_unidade_saude'] = $rows->no_unidade_saude;
                    $this->casas[$conta_array]['unid_saude_no_bairro'] = $rows->unid_saude_no_bairro;
                    $this->casas[$conta_array]['nu_ine_principal'] = $rows->nu_ine_principal;
                    $this->casas[$conta_array]['nu_ine'] = $rows->nu_ine;
                    $this->casas[$conta_array]['no_equipe'] = $rows->no_equipe;
                    $this->casas[$conta_array]['nu_micro_area'] = $rows->nu_micro_area;
                    $this->casas[$conta_array]['co_dim_tempo'] = $rows->co_dim_tempo;
                    $this->casas[$conta_array]['st_mudou'] = $rows->st_mudou;
                    $this->casas[$conta_array]['dt_inicio_residencia'] = $rows->dt_inicio_residencia;
                    $this->casas[$conta_array]['st_domicilio_ativo'] = $rows->st_domicilio_ativo;
                    $this->casas[$conta_array]['qt_morador'] = $rows->qt_morador;
                    $this->casas[$conta_array]['ds_complemento'] = $rows->ds_complemento;
                    $this->casas[$conta_array]['no_logradouro'] = $rows->no_logradouro;
                    $this->casas[$conta_array]['no_bairro'] = $rows->no_bairro;
                    $this->casas[$conta_array]['ds_cep'] = $rows->ds_cep;
                    $this->casas[$conta_array]['nu_fone_referencia'] = $rows->nu_fone_referencia;
                    $this->casas[$conta_array]['nu_fone_residencia'] = $rows->nu_fone_residencia;
                    $this->casas[$conta_array]['nu_domicilio'] = $rows->nu_domicilio;
                    $this->casas[$conta_array]['st_fora_area'] = $rows->st_fora_area;
                    $this->casas[$conta_array]['ds_ponto_referencia'] = $rows->ds_ponto_referencia;
                    $this->casas[$conta_array]['prof_nu_cns'] = $rows->prof_nu_cns;
                    $this->casas[$conta_array]['prof_no_profissional'] = $rows->prof_no_profissional;
                    $this->casas[$conta_array]['nu_cbo'] = $rows->nu_cbo;
                    $this->casas[$conta_array]['no_cbo'] = $rows->no_cbo;
                    $this->casas[$conta_array]['no_tipo_logradouro'] = $rows->no_tipo_logradouro;
                    $this->casas[$conta_array]['no_uf'] = $rows->no_uf;
                    $this->casas[$conta_array]['sg_uf'] = $rows->sg_uf;
                    $this->casas[$conta_array]['no_municipio'] = $rows->no_municipio;
                    $this->casas[$conta_array]['co_ibge'] = $rows->co_ibge;
                    $this->casas[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
                    $this->casas[$conta_array]['nome'] = '';
                    $this->casas[$conta_array]['mae'] = '';
                    $rsn = $this->con->prepare($this->sql3);
                    $rsn->bindParam(1,$rows->nu_cns_responsavel);
                    $rsn->bindParam(2,$rows->nu_cpf_responsavel);
                    if($rsn->execute()){
                        if($rsn->rowCount() > 0){
                            while($rowsn = $rsn->fetch(PDO::FETCH_OBJ)){
                                $this->casas[$conta_array]['nome'] = $rowsn->no_cidadao;
                                $this->casas[$conta_array]['mae'] = $rowsn->no_mae;
                            }
                        }
                    }
					$conta_array++;
				}
			}
		}
    }
    public function total() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			$this->totalEncontrado = $rs->rowCount();
            if ($this->totalEncontrado > 0){
                $this->ok = true;
            }
		}
    }
}
?>