<?php
class Clinicos {
    public $dti;
	public $dtf;
	public $cids = array();
	public $ciaps = array();
	public $cbos = array();
	public $idi;
	public $idf;
	public $sexo;
	public $tpi;
	public $ndti;
	public $ndtf;
	
	public $totalEncontrado;
	public $clinicos = array();
	public $ok;
	public $sql1;
	
	private $con;

    public function __construct($con, $cids, $ciaps, $cbos, $dti = 0, $dtf = 0, $idi = 0, $idf = 0, $sexo = 'T', $tpi = 1) {
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->con = $con;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->cids = $cids;
		$this->ciaps = $ciaps;
		$this->cbos = $cbos;
		$this->idi = $idi;
		$this->idf = $idf;
		$this->tpi = $tpi;
		$this->sexo = strtoupper($sexo);

		$this->ndti = '0000-00-00';
		$this->ndtf = '0000-00-00';
		if ($dti == $dtf){
			if ($dti > 0){
				$this->ndti = $this->ardata($this->nvdata($dti,($idf*$tpi)));
				$this->ndtf = $this->ndti;
			}
		} else {
			if ($dtf > 0){
				if ($dtf > $dti){
					$this->ndti = $this->ardata($this->nvdata($dti,($idf*$tpi)));
					$this->ndtf = $this->ardata($this->nvdata($dtf,($idi*$tpi)));
				}
			} else {
				if ($idi > 0){
					$this->ndti = $this->ardata($this->nvdata($dti,($idf*$tpi)));
					$this->ndtf = $this->ndti;
				}
			}
		}

		// Where 1 -------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------
		$where1 = "";
		
		$w_idade = "";
		if ($this->ndti != '0000-00-00'){
			if ($idi == $idf){
				if ($idi > 0){
					$w_idade = "(dt_nascimento >= '".$this->ndti."' AND dt_nascimento <= '".$this->ndtf."')";
				}
			} else {
				if ($idf > 0){
					if ($idf > $idi){
						$w_idade = "(dt_nascimento >= '".$this->ndti."' AND dt_nascimento <= '".$this->ndtf."')";
					}
				} else {
					if ($idi > 0){
						$w_idade = "dt_nascimento = '".$this->ndti."'";
					}
				}
			}
		}
		if (strlen($w_idade) > 0){
			$where1 = "WHERE ".$w_idade;
		}
		$w_ciaps = "";
		if (count($this->ciaps) > 0){
			$w_ciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($this->ciaps as $v) {
				$w_ciaps .= "'%|".$v."|%',";
			}
			$w_ciaps = substr($w_ciaps,0,-1);
			$w_ciaps .= "])";
		}
		$w_cids = "";
		if (count($this->cids) > 0){
			$w_cids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($this->cids as $v) {
				$w_cids .= "'%|".$v."|%',";
			}
			$w_cids = substr($w_cids,0,-1);
			$w_cids .= "])";
		}
		$w_cc = "";
		if (strlen($w_ciaps) > 0){
			$w_cc = $w_ciaps;
			if (strlen($w_cids) > 0){
				$w_cc = "(".$w_cc." OR ".$w_cids.")";
			}
		} else {
			if (strlen($w_cids) > 0){
				$w_cc = $w_cids;
			}
		}
		if (strlen($w_cc) > 0 && strlen($w_idade) > 0){
			$where1 = " AND ".$w_cc;
		} else {
			if (strlen($w_cc) > 0 && strlen($w_idade) <= 0){
				$where1 = "WHERE ".$w_cc;
			}
		}
		$w_tempo = "";
		if ($dti > 0){
			$w_tempo = "co_dim_tempo >= ".$dti;
			if ($dtf > 0 && $dtf > $dti){
				$w_tempo = "(co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")";
			}
		}
		if (strlen($where1) > 0 && strlen($w_tempo) > 0){
			$where1 = $where1." AND ".$w_tempo;
		} else {
			if (strlen($w_tempo) > 0){
				$where1 = "WHERE ".$w_tempo;
			}
		}

		// ---------------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------
		
		// Where 2 -------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------
		$where2 = "";
		
		$w_cbos = "";
		if (count($this->cbos) > 0){
			$w_cbos = "nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$w_cbos .= "'".$v."%',";
			}
			$w_cbos = substr($w_cbos,0,-1);
			$w_cbos .= "])";
		}
		if (strlen($w_cbos) > 0){
			$where2 = "WHERE ".$w_cbos;
		}
		$w_sexo = "";
		if ($this->sexo != 'T'){
			$w_sexo = "no_sexo = '".$this->sexo."'";
		}
		if (strlen($w_sexo) > 0 && strlen($w_cbos) > 0){
			$where2 = " AND ".$w_sexo;
		} else {
			if (strlen($w_sexo) > 0 && strlen($w_cbos) <= 0){
				$where2 = "WHERE ".$w_sexo;
			}
		}
		// ---------------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------

		$this->sql1 = "
			SELECT 
				tb1.*,
				tb_fat_cidadao_pec.co_cidadao
			FROM
			(
				SELECT DISTINCT ON (co_fat_cidadao_pec)  
					*
				FROM 
				(
					SELECT
						t3.*,
						upper(tb_dim_sexo.ds_sexo) no_sexo
					FROM
					(
						SELECT  
							t1.*, 
							tb_dim_cbo.nu_cbo 
						FROM 
						( 
							SELECT 
								CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2 
								ELSE co_dim_cbo_1 END 
								co_dim_cbo,  
								co_fat_cidadao_pec,
								dt_nascimento,
								nu_cns,
								nu_cpf_cidadao,
								co_dim_sexo,
								co_dim_tempo
							FROM 
								tb_fat_atendimento_individual 
							".$where1." 
							ORDER BY co_fat_cidadao_pec, co_dim_tempo
						) AS t1 
						LEFT JOIN 
							tb_dim_cbo 
						ON tb_dim_cbo.co_seq_dim_cbo = t1.co_dim_cbo 
					) AS t3
					JOIN
						tb_dim_sexo
					ON tb_dim_sexo.co_seq_dim_sexo = t3.co_dim_sexo
				) AS t2 
				".$where2."
				ORDER BY co_fat_cidadao_pec, co_dim_tempo
			) AS tb1
			LEFT JOIN
				tb_fat_cidadao_pec
			ON tb_fat_cidadao_pec.co_seq_fat_cidadao_pec = tb1.co_fat_cidadao_pec
		";

    }

    public function todos() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->clinicos[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
					$this->clinicos[$conta_array]['cidadao2'] = $rows->co_cidadao;
					$this->clinicos[$conta_array]['dtConsulta'] = $rows->co_dim_tempo;
					$this->clinicos[$conta_array]['cns'] = $rows->nu_cns;
					$this->clinicos[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$conta_array++;
				}
			}
		}
		$this->totalEncontrado = $conta_array;
    }
	
	private function nvdata($data,$meses=0){  // $data int 20210225 e retorna int Ymd
		$novadata = $data;
		$ano = (int) substr($data,0,4);
		$mes = (int) substr($data,4,2);
		$dia = (int) substr($data,6,2);
		$tmes = "month";
		$novadata = date('Ymd', strtotime('-'.$meses.' '.$tmes, strtotime($dia.'-'.$mes.'-'.$ano)));
		return $novadata;
	}
	
	private function ardata($data){ // 20210320 e transforma em 2021-03-20
		$ndi = substr($data,0,4)."-".substr($data,4,2)."-".substr($data,6,2);
		return $ndi;
	}

}


class ClinicoFAT {
    public $dti;
	public $dtf;
	public $cids = array();
	public $ciaps = array();
	public $cbos = array();
	
	public $ok;
	public $sql1;
	
	private $con;
	private $cfat;

    public function __construct($con, $cfat, $cids, $ciaps, $cbos, $dti = 0, $dtf = 0) {
		$this->ok = false;
		$this->con = $con;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->cids = $cids;
		$this->ciaps = $ciaps;
		$this->cbos = $cbos;
		$this->cfat = $cfat;

		// Where 1 -------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------
		$where1 = "WHERE co_fat_cidadao_pec = ".$cfat;

		$w_ciaps = "";
		if (count($this->ciaps) > 0){
			$w_ciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($this->ciaps as $v) {
				$w_ciaps .= "'%|".$v."|%',";
			}
			$w_ciaps = substr($w_ciaps,0,-1);
			$w_ciaps .= "])";
		}
		$w_cids = "";
		if (count($this->cids) > 0){
			$w_cids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($this->cids as $v) {
				$w_cids .= "'%|".$v."|%',";
			}
			$w_cids = substr($w_cids,0,-1);
			$w_cids .= "])";
		}
		$w_cc = "";
		if (strlen($w_ciaps) > 0){
			$w_cc = $w_ciaps;
			if (strlen($w_cids) > 0){
				$w_cc = "(".$w_cc." OR ".$w_cids.")";
			}
		} else {
			if (strlen($w_cids) > 0){
				$w_cc = $w_cids;
			}
		}
		if (strlen($w_cc) > 0){
			$where1 = $where1." AND ".$w_cc;
		}
		$w_tempo = "";
		if ($dti > 0){
			$w_tempo = "co_dim_tempo >= ".$dti;
			if ($dtf > 0 && $dtf > $dti){
				$w_tempo = "(co_dim_tempo >= ".$dti." AND co_dim_tempo <= ".$dtf.")";
			}
		}
		if (strlen($w_tempo) > 0){
			$where1 = $where1." AND ".$w_tempo;
		}
		// ---------------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------
		
		// Where 2 -------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------
		$where2 = "";
		
		$w_cbos = "";
		if (count($this->cbos) > 0){
			$w_cbos = "nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$w_cbos .= "'".$v."%',";
			}
			$w_cbos = substr($w_cbos,0,-1);
			$w_cbos .= "])";
		}
		if (strlen($w_cbos) > 0){
			$where2 = "WHERE ".$w_cbos;
		}
		// ---------------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------

		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT  
					t1.*, 
					tb_dim_cbo.nu_cbo 
				FROM 
				( 
					SELECT 
						CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2 
						ELSE co_dim_cbo_1 END 
						co_dim_cbo,  
						co_dim_tempo
					FROM 
						tb_fat_atendimento_individual 
					".$where1." 
					ORDER BY co_dim_tempo
					LIMIT 1
				) AS t1 
				LEFT JOIN 
					tb_dim_cbo 
				ON tb_dim_cbo.co_seq_dim_cbo = t1.co_dim_cbo 
			) AS tf
			".$where2."
			ORDER BY co_dim_tempo
			LIMIT 1
		";
		$rs = $this->con->query($this->sql1);
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->ok = true;
			}
		}
    }
}


?>



