<?php
class Gestantes {
    public $dti;
	public $dtf;
	public $dpp;
    public $ndti;
	public $ndtf;
	public $smct;
	public $totalEncontrado;
	public $gestantes = array();
	public $ok;
	public $sql1;
	
	private $con;
	private $cids = array('ABP001','O11','O120','O121','O122','O13','O140','O141','O149','O150','O151','O159','O16','O200','O208','O209','O210','O211','O212','O218','O219','O220','O221','O222','O223','O224','O225','O228','O229','O230','O231','O232','O233','O234','O235','O239','O299','O300','O301','O302','O308','O309','O311','O312','O318','O320','O321','O322','O323','O324','O325','O326','O328','O329','O330','O331','O332','O333','O334','O335','O336','O337','O338','O752','O753','O990','O991','O992','O993','O994','O240','O241','O242','O243','O244','O249','O25','O260','O261','O263','O264','O265','O268','O269','O280','O281','O282','O283','O284','O285','O288','O289','O290','O291','O292','O293','O294','O295','O296','O298','O009','O339','O340','O341','O342','O343','O344','O345','O346','O347','O348','O349','O350','O351','O352','O353','O354','O355','O356','O357','O358','O359','O360','O361','O362','O363','O365','O366','O367','O368','O369','O40','O410','O411','O418','O419','O430','O431','O438','O439','O440','O441','O460','O468','O469','O470','O471','O479','O48','O995','O996','O997','Z640','O00','O10','O12','O14','O15','O20','O21','O22','O23','O24','O26','O28','O29','O30','O31','O32','O33','O34','O35','O36','O41','O43','O44','O46','O47','O98','Z34','Z35','Z36','Z321','Z33','Z340','Z340','Z348','Z349','Z350','Z351','Z352','Z353','Z354','Z357','Z358','Z359');
	private $ciaps = array('ABP001','W03','W05','W29','W71','W78','W79','W80','W81','W84','W85');
	private $cbos = array('2251','2252','2253','2231','2235');

    public function __construct($con, $dti, $dtf, $dpp = 294) {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->dpp = $dpp;
		$this->con = $con;
		$this->ndti = $this->datasomadias($dti,$dpp,'-');
		$this->ndtf = $this->datasomadias($dtf,$dpp,'-');
		$this->smct = $this->dsemanas($dti,$dtf);
		
		$tciaps = "";
		if (count($this->ciaps) > 0){
			$tciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($this->ciaps as $v) {
				$tciaps .= "'%|".$v."|%',";
			}
			$tciaps = substr($tciaps,0,-1);
			$tciaps .= "])";
		}
		$tcids = "";
		if (count($this->cids) > 0){
			$tcids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($this->cids as $v) {
				$tcids .= "'%|".$v."|%',";
			}
			$tcids = substr($tcids,0,-1);
			$tcids .= "])";
		}
		$cc = "";
		if (strlen($tciaps) > 0){
			$cc = $tciaps;
			if (strlen($tcids) > 0){
				$cc = "(".$cc." OR ".$tcids.")";
			}
		} else {
			if (strlen($tcids) > 0){
				$cc = $tcids;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}

		$this->sql1 = "
			SELECT 
				tb1.*,
				tb_fat_cidadao_pec.co_cidadao
			FROM
			(
				SELECT DISTINCT ON (co_fat_cidadao_pec)  
					*
				FROM 
				(
					SELECT  
						t1.*, 
						tb_dim_cbo.nu_cbo 
					FROM 
					( 
						SELECT 
							CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2 
							ELSE co_dim_cbo_1 END 
							co_dim_cbo,  
							co_fat_cidadao_pec,
							nu_idade_gestacional_semanas,
							co_dim_tempo_dum,
							co_dim_tempo,
							nu_cns,
							nu_cpf_cidadao,
							dt_nascimento,
							co_dim_sexo
						FROM 
							tb_fat_atendimento_individual 
						WHERE 
						(
							(co_dim_tempo_dum >= ".$this->ndti." AND co_dim_tempo_dum <= ".$this->ndtf.") 
							OR 
							(co_dim_tempo >= ".$this->ndti." AND nu_idade_gestacional_semanas >= ".$this->smct.")
						) ".$cc."  
						ORDER BY co_fat_cidadao_pec, co_dim_tempo_dum, co_dim_tempo, nu_idade_gestacional_semanas
					) AS t1 
					LEFT JOIN 
						tb_dim_cbo 
					ON tb_dim_cbo.co_seq_dim_cbo = t1.co_dim_cbo 
				) AS t2 
				".$tcbos."
				ORDER BY co_fat_cidadao_pec, co_dim_tempo_dum, co_dim_tempo, nu_idade_gestacional_semanas
			) AS tb1
			LEFT JOIN
				tb_fat_cidadao_pec
			ON tb_fat_cidadao_pec.co_seq_fat_cidadao_pec = tb1.co_fat_cidadao_pec
		";

    }

    public function todos() {
		$rs = $this->con->query($this->sql1);
		$conta_array = 0;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->ok = true;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){
					$this->gestantes[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
					$this->gestantes[$conta_array]['cidadao2'] = $rows->co_cidadao;
					$this->gestantes[$conta_array]['cidadaoc'] = $rows->co_cidadao;
					$this->gestantes[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
					$this->gestantes[$conta_array]['cns'] = $rows->nu_cns;
					$this->gestantes[$conta_array]['semRef'] = 0;
					$this->gestantes[$conta_array]['dtConsI'] = $this->ndti;
					if ($rows->co_dim_tempo_dum > 0 && $rows->co_dim_tempo_dum < 30001231){
						$this->gestantes[$conta_array]['dtConsI'] = $rows->co_dim_tempo_dum;
					} else {
						if ($rows->nu_idade_gestacional_semanas > 0 && $rows->nu_idade_gestacional_semanas < 42){
							$ndias = (42 - $rows->nu_idade_gestacional_semanas) * 7;
							$dppig = $this->datasomadias($rows->co_dim_tempo,$ndias);
							if ($dppig >= $this->dti && $dppig <= $this->dtf){
								$ndias = $rows->nu_idade_gestacional_semanas * 7;
								$this->gestantes[$conta_array]['dtConsI'] = $this->datasomadias($rows->co_dim_tempo,$ndias,'-');
							} else {
								$this->gestantes[$conta_array]['semRef'] = 1;
							}
						}
					}
					$this->gestantes[$conta_array]['dtConsF'] = $this->dtf;
					$conta_array++;
				}
			}
		}
		$this->totalEncontrado = $conta_array;
    }
	
	private function datasomadias($data,$dias=0,$operador='+'){  // $data int 20210225 e retorna int Ymd
		$novadata = $data;
		$ano = (int) substr($data,0,4);
		$mes = (int) substr($data,4,2);
		$dia = (int) substr($data,6,2);
		$tdia = "days";
		if ($dias == 1){
			$tdia = "day";
		}
		$novadata = date('Ymd', strtotime($operador.$dias.' '.$tdia, strtotime($dia.'-'.$mes.'-'.$ano)));
		return $novadata;
	}

	private function dsemanas($data1,$data2){ // as duas datas no formato yyyymmdd (dt1 menor que dt2)
		$data1 = substr($data1,0,4)."-".substr($data1,4,2)."-".substr($data1,6,2);
		$data2 = substr($data2,0,4)."-".substr($data2,4,2)."-".substr($data2,6,2);
		$d1 = strtotime($data1); 
		$d2 = strtotime($data2);
		$dias = ($d2 - $d1) /86400;
		if($dias < 0){
			$dias *= -1;
		}
		$semanas = floor($dias) / 7;
		return  floor($semanas);	
	}

}

// ***********************************************************************************************************
// ***********************************************************************************************************
// ***********************************************************************************************************
// ***********************************************************************************************************
// ***********************************************************************************************************
// ***********************************************************************************************************

class GestantesNV {
    public $dti;
	public $dtf;
	public $dpp;
	public $dc;
    public $ndti;
	public $ndtf;
	public $smct;
	public $totalEncontrado;
	public $gestantes = array();
	public $ok;
	public $sql1;
	
	private $con;
    // ----------------------------------------------------------
    private $cids = array('ABP001','O11','O120','O121','O122','O13','O140','O141','O149','O150','O151','O159','O16','O200','O208','O209','O210','O211','O212','O218','O219','O220','O221','O222','O223','O224','O225','O228','O229','O230','O231','O232','O233','O234','O235','O239','O299','O300','O301','O302','O308','O309','O311','O312','O318','O320','O321','O322','O323','O324','O325','O326','O328','O329','O330','O331','O332','O333','O334','O335','O336','O337','O338','O752','O753','O990','O991','O992','O993','O994','O240','O241','O242','O243','O244','O249','O25','O260','O261','O263','O264','O265','O268','O269','O280','O281','O282','O283','O284','O285','O288','O289','O290','O291','O292','O293','O294','O295','O296','O298','O009','O339','O340','O341','O342','O343','O344','O345','O346','O347','O348','O349','O350','O351','O352','O353','O354','O355','O356','O357','O358','O359','O360','O361','O362','O363','O365','O366','O367','O368','O369','O40','O410','O411','O418','O419','O430','O431','O438','O439','O440','O441','O460','O468','O469','O470','O471','O479','O48','O995','O996','O997','Z640','O00','O10','O12','O14','O15','O20','O21','O22','O23','O24','O26','O28','O29','O30','O31','O32','O33','O34','O35','O36','O41','O43','O44','O46','O47','O98','Z34','Z35','Z36','Z321','Z33','Z340','Z348','Z349','Z350','Z351','Z352','Z353','Z354','Z357','Z358','Z359');
    // ----------------------------------------------------------
    private $ciaps = array('ABP001','W03','W05','W29','W71','W78','W79','W80','W81','W84','W85');
	// ----------------------------------------------------------
	private $cbos = array('2251','2252','2253','2231','2235');

    public function __construct($con, $dti, $dtf, $dpp = 294, $dc = 'P') {
		$this->totalEncontrado = 0;
		$this->ok = false;
        $this->dti = $dti;
		$this->dtf = $dtf;
		$this->dpp = $dpp;
		$this->dc = $dc;
		$this->con = $con;
		$this->ndti = $this->datasomadias($dti,$dpp,'-');
		$this->ndtf = $this->datasomadias($dtf,($dpp-45),'-');
		$this->smct = $this->dsemanas($dti,$dtf);

		// *********************************************************
		$tciaps = "";
		if (count($this->ciaps) > 0){
			$tciaps = "ds_filtro_ciaps LIKE ANY (array[";
			foreach ($this->ciaps as $v) {
				$tciaps .= "'%|".$v."|%',";
			}
			$tciaps = substr($tciaps,0,-1);
			$tciaps .= "])";
		}
		$tcids = "";
		if (count($this->cids) > 0){
			$tcids = "ds_filtro_cids LIKE ANY (array[";
			foreach ($this->cids as $v) {
				$tcids .= "'%|".$v."|%',";
			}
			$tcids = substr($tcids,0,-1);
			$tcids .= "])";
		}
		$cc = "";
		if (strlen($tciaps) > 0){
			$cc = $tciaps;
			if (strlen($tcids) > 0){
				$cc = "(".$cc." OR ".$tcids.")";
			}
		} else {
			if (strlen($tcids) > 0){
				$cc = $tcids;
			}
		}
		if (strlen($cc) > 0){
			$cc = " AND ".$cc;
		}
		// *********************************************************
		$tcbos = "";
		if (count($this->cbos) > 0){
			$tcbos = "WHERE nu_cbo LIKE ANY (array[";
			foreach ($this->cbos as $v) {
				$tcbos .= "'".$v."%',";
			}
			$tcbos = substr($tcbos,0,-1);
			$tcbos .= "])";
		}

		$this->sql1 = "
			SELECT
				*
			FROM
			(
				SELECT 
					t2.*, 
					tb_fat_cidadao_pec.co_cidadao,
					tb_fat_cidadao_pec.co_seq_fat_cidadao_pec AS co_fat_cidadao_pec_2
				FROM 
				(
					SELECT
						t1b.*,
						tb_dim_sexo.sg_sexo
					FROM
					(
						SELECT 
							t1.*, 
							tb_dim_cbo.nu_cbo 
						FROM 
						( 
							SELECT 
								CASE WHEN co_dim_cbo_1 = 1 THEN co_dim_cbo_2 ELSE co_dim_cbo_1 END co_dim_cbo, 
								co_fat_cidadao_pec, 
								nu_idade_gestacional_semanas, 
								co_dim_tempo_dum, 
								co_dim_tempo, 
								nu_cns, 
								nu_cpf_cidadao,
								ds_filtro_ciaps,
								ds_filtro_cids,
								dt_nascimento,
								co_dim_sexo
							FROM 
								tb_fat_atendimento_individual 
							WHERE 
							( 
								(co_dim_tempo_dum >= ".$this->ndti." AND co_dim_tempo_dum <= ".$this->ndtf.") 
								OR 
								((co_dim_tempo >= ".$this->ndti." AND nu_idade_gestacional_semanas > 0) AND (co_dim_tempo <= ".$this->dtf." AND nu_idade_gestacional_semanas <= 42))
							) 
							".$cc."  
						) AS t1 
						LEFT JOIN 
							tb_dim_cbo 
						ON tb_dim_cbo.co_seq_dim_cbo = t1.co_dim_cbo 
					) AS t1b
					LEFT JOIN 
						tb_dim_sexo 
					ON tb_dim_sexo.co_seq_dim_sexo = t1b.co_dim_sexo 
				) AS t2
				LEFT JOIN 
					tb_fat_cidadao_pec 
				--ON (tb_fat_cidadao_pec.nu_cns = t2.nu_cns OR tb_fat_cidadao_pec.nu_cpf_cidadao = t2.nu_cpf_cidadao) AND tb_fat_cidadao_pec.co_seq_fat_cidadao_pec <> t2.co_fat_cidadao_pec
				ON tb_fat_cidadao_pec.co_seq_fat_cidadao_pec = t2.co_fat_cidadao_pec
			) AS t3 
			".$tcbos."
			ORDER BY co_fat_cidadao_pec, co_dim_tempo, co_dim_tempo_dum, nu_idade_gestacional_semanas
		";

    }

    public function todos() {
		$rs = $this->con->query($this->sql1);
		$conta_array = -1;
		if($rs->execute()){
			if($rs->rowCount() > 0){
				$this->ok = true;
				$id_gestante = 0;
				$id_banido = 0;
				while($rows = $rs->fetch(PDO::FETCH_OBJ)){

					$con_cid = str_replace(" ","",substr(substr($rows->ds_filtro_cids,0,-1),1));
					$con_ciap = str_replace(" ","",substr(substr($rows->ds_filtro_ciaps,0,-1),1));
					$array_con_cid = explode("|",$con_cid);
					$array_con_ciap = explode("|",$con_ciap);
					$apenas_cids_pn = array_intersect($array_con_cid,$this->cids);
					$apenas_ciaps_pn = array_intersect($array_con_ciap,$this->ciaps);

					$consulta_pn = false;
					if (count($apenas_cids_pn) > 0 || count($apenas_ciaps_pn) > 0){
						$consulta_pn = true;
					}

					$dum_considerar = 0;
					$dum_considerar_dum = 0;
					$dum_considerar_ig = 0;
					if ($rows->co_dim_tempo_dum > 0 && $rows->co_dim_tempo_dum < 30001231){
						$dppdum = $this->datasomadias($rows->co_dim_tempo_dum,$this->dpp);
						if ($dppdum >= $this->dti && $dppdum <= $this->dtf){
							$dum_considerar_dum = $rows->co_dim_tempo_dum;
						}
					}
					if ($rows->nu_idade_gestacional_semanas > 0 && $rows->nu_idade_gestacional_semanas < 42){
						$ndias = (42 - $rows->nu_idade_gestacional_semanas) * 7;
						$dppig = $this->datasomadias($rows->co_dim_tempo,$ndias);
						if ($dppig >= $this->dti && $dppig <= $this->dtf){
							$ndias = $rows->nu_idade_gestacional_semanas * 7;
							$dum_considerar_ig = $this->datasomadias($rows->co_dim_tempo,$ndias,'-');
						}
					}
					if ($dum_considerar_dum > 0){
						if ($dum_considerar_ig > 0){
							/*
							if ($dum_considerar_dum < $dum_considerar_ig){
								$dum_considerar = $dum_considerar_dum;
							} else {
								$dum_considerar = $dum_considerar_ig;
							}
							*/
							$dum_considerar = $dum_considerar_ig;
						} else {
							$dum_considerar = $dum_considerar_dum;
						}
						
					} else {
						$dum_considerar = $dum_considerar_ig;
					}
					if ($dum_considerar > 0){
						if ($rows->co_fat_cidadao_pec != $id_banido){
							$dpp_considerar = $this->datasomadias($dum_considerar,$this->dpp);
							if ($dpp_considerar >= $this->dti && $dpp_considerar <= $this->dtf){
								if ($rows->co_fat_cidadao_pec != $id_gestante){
									if ($consulta_pn){
										$dtNascimento = 0;
										if (strlen($rows->dt_nascimento) > 0){
											$dtNascimento = (int) substr($rows->dt_nascimento,0,4).substr($rows->dt_nascimento,5,2).substr($rows->dt_nascimento,8,2);
										}
										$conta_array++;
										$this->gestantes[$conta_array]['cidadao'] = $rows->co_fat_cidadao_pec;
										$this->gestantes[$conta_array]['cidadao2'] = $rows->co_fat_cidadao_pec_2;
										$this->gestantes[$conta_array]['cidadaoc'] = $rows->co_cidadao;
										$this->gestantes[$conta_array]['cpf'] = $rows->nu_cpf_cidadao;
										$this->gestantes[$conta_array]['cns'] = $rows->nu_cns;
										$this->gestantes[$conta_array]['sexo'] = $rows->sg_sexo;
										$this->gestantes[$conta_array]['dtNascimento'] = $dtNascimento;
										$this->gestantes[$conta_array]['con1cDoI'] = $rows->co_dim_tempo;
										$this->gestantes[$conta_array]['dum_primeiro'] = $dum_considerar;
										$this->gestantes[$conta_array]['dtConsF'] = $this->dtf;
										$this->gestantes[$conta_array]['dtConsI'] = $dum_considerar;
										$this->gestantes[$conta_array]['dpp'] = $dpp_considerar;
										$this->gestantes[$conta_array]['dum_antigo'] = $dum_considerar;
										$this->gestantes[$conta_array]['dum_novo'] = $dum_considerar;
										$this->gestantes[$conta_array]['dum_ultimo'] = $dum_considerar;
										$id_gestante = $rows->co_fat_cidadao_pec;
									}
								} else {
									$this->gestantes[$conta_array]['dum_ultimo'] = $dum_considerar;
									if ($dum_considerar < $this->gestantes[$conta_array]['dtConsI']){
										$this->gestantes[$conta_array]['dtConsI'] = $dum_considerar;
										$this->gestantes[$conta_array]['dum_antigo'] = $dum_considerar;
									}
									if ($dum_considerar > $this->gestantes[$conta_array]['dum_novo']){
										$this->gestantes[$conta_array]['dum_novo'] = $dum_considerar;
									}
									if ($this->dc == 'A'){
										$this->gestantes[$conta_array]['dpp'] = $this->datasomadias($this->gestantes[$conta_array]['dum_antigo'],$this->dpp);
									}
									if ($this->dc == 'N'){
										$this->gestantes[$conta_array]['dpp'] = $this->datasomadias($this->gestantes[$conta_array]['dum_novo'],$this->dpp);
									}
									if ($this->dc == 'U'){
										$this->gestantes[$conta_array]['dpp'] = $dpp_considerar;
									}
								}
							}
						}
					} else {
						$id_banido = $rows->co_fat_cidadao_pec;
					}
				}
			}
		}
		$this->totalEncontrado = count($this->gestantes);
    }
	
	private function datasomadias($data,$dias=0,$operador='+'){  // $data int 20210225 e retorna int Ymd
		$novadata = $data;
		$ano = (int) substr($data,0,4);
		$mes = (int) substr($data,4,2);
		$dia = (int) substr($data,6,2);
		$tdia = "days";
		if ($dias == 1){
			$tdia = "day";
		}
		$novadata = date('Ymd', strtotime($operador.$dias.' '.$tdia, strtotime($dia.'-'.$mes.'-'.$ano)));
		return $novadata;
	}

	private function dsemanas($data1,$data2){ // as duas datas no formato yyyymmdd (dt1 menor que dt2)
		$data1 = substr($data1,0,4)."-".substr($data1,4,2)."-".substr($data1,6,2);
		$data2 = substr($data2,0,4)."-".substr($data2,4,2)."-".substr($data2,6,2);
		$d1 = strtotime($data1); 
		$d2 = strtotime($data2);
		$dias = ($d2 - $d1) /86400;
		if($dias < 0){
			$dias *= -1;
		}
		$semanas = floor($dias) / 7;
		return  floor($semanas);	
	}

}


class GestantesSISABD {
	public $totalEncontrado;
	public $ok;
	public $sql;
	public $gestantes = array();
	public $ref;
	public $idu;
	public $ibge;
	public $dpp;
	public $quadrimestre;
	private $con;
	public $tabela;
    public function __construct($con, $ref, $idu, $ibge, $quadrimestre, $tabela) {
		$this->dpp = 294;
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->sql = '';
		$this->gestantes = array();
		$this->ref = $ref;
		$this->idu = $idu;
		$this->ibge = $ibge;
		$this->quadrimestre = $quadrimestre;
		$this->con = $con;
		$this->tabela = $tabela;
		if ($this->ref != ''){
			$this->sql = "SELECT * FROM ".$this->tabela." WHERE id = '".$this->idu."' AND ibge = '".$this->ibge."' AND ref = '".$this->ref."' AND quadrimestre = '".$this->quadrimestre."'";
		}
	}
    public function todos() {
		if ($this->ref != ''){
			$rs = $this->con->query($this->sql);
			$conta_array = 0;
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
					while($rows = $rs->fetch(PDO::FETCH_OBJ)){
						$this->gestantes[$conta_array]['cns'] = trim($rows->cns);
						$this->gestantes[$conta_array]['cpf'] = trim($rows->cpf);
						$this->gestantes[$conta_array]['cidadao'] = trim($rows->cidadao);
						$this->gestantes[$conta_array]['cidadaoc'] = trim($rows->cidadaoc);
						if (strlen($this->gestantes[$conta_array]['cidadao']) <= 0){
							$this->gestantes[$conta_array]['cidadao'] = '0';
						}
						if (strlen($this->gestantes[$conta_array]['cidadaoc']) <= 0){
							$this->gestantes[$conta_array]['cidadaoc'] = '0';
						}
						$this->gestantes[$conta_array]['ine'] = $rows->ine;
						$this->gestantes[$conta_array]['cnes'] = $rows->cnes;
						$this->gestantes[$conta_array]['nome'] = $rows->nome;
						$this->gestantes[$conta_array]['dtNascimento'] = $rows->dtnas;
						$this->gestantes[$conta_array]['local'] = $rows->local;
						$this->gestantes[$conta_array]['dum_primeiro'] = $rows->dum;
						$this->gestantes[$conta_array]['dtConsI'] = $rows->dtini;
						$this->gestantes[$conta_array]['dtConsF'] = $rows->dtfin;
						$this->gestantes[$conta_array]['sexo'] = 'F';
						$this->gestantes[$conta_array]['aborto'] = trim($rows->aborto);
						$this->gestantes[$conta_array]['dpp'] = $rows->dpp;
						$this->gestantes[$conta_array]['con1cDoI'] = $rows->con1cDoI;
						$this->gestantes[$conta_array]['cidadao2'] = $rows->cidadao2;
						$conta_array++;
					}
				}
			}
		}
	}
    public function total() {
		if ($this->ref != ''){
			$rs = $this->con->query($this->sql);
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
				}
			}
		}
    }
}

class GestantesSISABC {
	public $totalEncontrado;
	public $ok;
	public $sql;
	public $gestantes = array();
	public $indicador;
	public $idu;
	public $ibge;
	public $dpp;
	private $con;
	public $tabela;
    public function __construct($con, $indicador, $idu, $ibge, $tabela) {
		$this->dpp = 294;
		$this->totalEncontrado = 0;
		$this->ok = false;
		$this->sql = '';
		$this->gestantes = array();
		$this->indicador = $indicador;
		$this->idu = $idu;
		$this->ibge = $ibge;
		$this->con = $con;
		$this->tabela = $tabela;
		if ($this->indicador != ''){
			$this->sql = "SELECT * FROM ".$this->tabela." WHERE id = '".$this->idu."' AND ibge = '".$this->ibge."' AND indicador = '".$this->indicador."'";
		}
	}
    public function todos() {
		if ($this->indicador != ''){
			$rs = $this->con->query($this->sql);
			$conta_array = 0;
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
					while($rows = $rs->fetch(PDO::FETCH_OBJ)){
						$this->gestantes[$conta_array]['cns'] = trim($rows->cns);
						$this->gestantes[$conta_array]['cpf'] = trim($rows->cpf);
						$this->gestantes[$conta_array]['cidadao'] = trim($rows->cidadao);
						$this->gestantes[$conta_array]['cidadaoc'] = trim($rows->cidadaoc);
						if (strlen($this->gestantes[$conta_array]['cidadao']) <= 0){
							$this->gestantes[$conta_array]['cidadao'] = '0';
						}
						if (strlen($this->gestantes[$conta_array]['cidadaoc']) <= 0){
							$this->gestantes[$conta_array]['cidadaoc'] = '0';
						}
						$this->gestantes[$conta_array]['ine'] = $rows->equipe;
						$this->gestantes[$conta_array]['nome'] = $rows->nome;
						$this->gestantes[$conta_array]['dtNascimento'] = $rows->dtn;
						$this->gestantes[$conta_array]['local'] = $rows->local;
						$this->gestantes[$conta_array]['dum_primeiro'] = $rows->dum;
						$this->gestantes[$conta_array]['dpp'] = $rows->dpp14;
						$this->gestantes[$conta_array]['con1cDoI'] = $rows->dt1c;
						$this->gestantes[$conta_array]['cidadao2'] = 0;
						$this->gestantes[$conta_array]['sexo'] = 'F';
						$this->gestantes[$conta_array]['cnes'] = $rows->cnes;
						$this->gestantes[$conta_array]['aborto'] = trim($rows->aborto); // nao esta sendo usado
						$this->gestantes[$conta_array]['dtConsI'] = $rows->dum; // gambiarra
						$this->gestantes[$conta_array]['dtConsF'] = $rows->dpp14; // gambiarra
						$conta_array++;
					}
				}
			}
		}
	}
    public function total() {
		if ($this->indicador != ''){
			$rs = $this->con->query($this->sql);
			if($rs->execute()){
				$this->totalEncontrado = $rs->rowCount();
				if($this->totalEncontrado > 0){
					$this->ok = true;
				}
			}
		}
    }
}






?>



