<?php
// +++++++ Verificacao ++++++++++++++++++++++++
$file = "ctrl.php";
if (!file_exists($file)){
    header('location:mensagem.php');
} else {
    require_once($file);
}
// ++++++++++++++++++++++++++++++++++++++++++++

require_once('cabecalho.php');
require_once('verificacao.php');
require_once('../core/functions.php');
require_once('../core/cfscp.php');
$idh = sha1(idh());

?>

<body class="horizontal-menu" data-framework="rss" data-asset-path="../app-assets/">
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper container-xxl p-0">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">Instalação <?php echo $sobre['nome']; ?> |
                                <?php echo $sobre['vsis']; ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <!-- Horizontal Wizard -->
                <section class="horizontal-wizard">
                    <div class="bs-stepper horizontal-wizard-example">
                        <div class="bs-stepper-header" role="tablist">
                            <!--
                            -----------------------------------------------------------------------------
                            PARTE 1
                            -----------------------------------------------------------------------------
                            -->
                            <div class="step" data-target="#verificacao" role="tab" id="verificacao-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">1</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Verificações</span>
                                    </span>
                                </button>
                            </div>
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <!--
                            -----------------------------------------------------------------------------
                            PARTE 2
                            -----------------------------------------------------------------------------
                            -->
                            <div class="step" data-target="#dados-pessoais" role="tab" id="dados-pessoais-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">2</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Dados pessoais</span>
                                    </span>
                                </button>
                            </div>
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <!--
                            -----------------------------------------------------------------------------
                            PARTE 3
                            -----------------------------------------------------------------------------
                            -->
                            <div class="step" data-target="#contrato" role="tab" id="contrato-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">3</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Contrato</span>

                                    </span>
                                </button>
                            </div>
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <!--
                            -----------------------------------------------------------------------------
                            PARTE 4
                            -----------------------------------------------------------------------------
                            -->
                            <div class="step" data-target="#bancodedados" role="tab" id="bancodedados-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">4</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Banco de dados</span>
                                    </span>
                                </button>
                            </div>
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <!--
                            -----------------------------------------------------------------------------
                            PARTE 5
                            -----------------------------------------------------------------------------
                            -->
                            <div class="step" data-target="#administrador" role="tab" id="administrador-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">5</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Administrador</span>
                                    </span>
                                </button>
                            </div>
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <!--
                            -----------------------------------------------------------------------------
                            PARTE 6
                            -----------------------------------------------------------------------------
                            -->
                            <div class="step" data-target="#final" role="tab" id="final-trigger">
                                <button type="button" class="step-trigger">
                                    <span class="bs-stepper-box">6</span>
                                    <span class="bs-stepper-label">
                                        <span class="bs-stepper-title">Final</span>
                                    </span>
                                </button>
                            </div>
                            <div class="line">
                                <i data-feather="chevron-right" class="font-medium-2"></i>
                            </div>
                            <!--
                            -----------------------------------------------------------------------------
                            Final
                            -----------------------------------------------------------------------------
                            -->
                        </div>
                        <div class="bs-stepper-content">
                            <!--
                            *****************************************************************************
                            PARTE 1 *********************************************************************
                            *****************************************************************************
                            -->
                            <div id="verificacao" class="content" role="tabpanel" aria-labelledby="verificacao-trigger">
                                <form id="form1" name="form1">
                                    <div class="content-header">
                                        <h5 class="mb-0">Verificação dos requisitos mínimos para a instalação</h5>
                                    </div>
                                    <table class="table table-striped table-sm">
                                        <thead>
                                            <tr>
                                                <th scope="col">Itens necessários</th>
                                                <th scope="col-2"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            // ++++++++++++++++++++++++++ Versao do PHP +++++++++++++++++++++++++++++
                                            $sim_nao_versao = "<input type=\"hidden\" name=\"php8\" id=\"php8\" value=\"0\" /><span class=\"badge rounded-pill bg-danger\"> <i data-feather=\"slash\"></i> NÃO</span> <a class=\"btn btn-relief-danger\" href=\"https://www.youtube.com/watch?v=A93gG673MVQ\" target=\"_blank\" role=\"button\"><i data-feather='youtube'></i> Atualizar PHP</a>";
                                            if ($ver_versao_php){
                                                $sim_nao_versao = "<input type=\"hidden\" name=\"php8\" id=\"php8\" value=\"1\" /><span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row col-2">PHP 8.0 / 8.1</th>
                                                <td><?php echo $sim_nao_versao;?></td>
                                            </tr>
                                            <?php
                                            // ++++++++++++++++++++++++++ Extensao PHP - SourceGuardian +++++++++++++++++++++++++++++
                                            $sim_nao_extensao = "<input type=\"hidden\" name=\"exsg\" id=\"exsg\" value=\"0\" /><span class=\"badge rounded-pill bg-danger\"> <i data-feather=\"slash\"></i> NÃO</span> <a class=\"btn btn-relief-danger\" href=\"https://www.youtube.com/watch?v=StpQwB-SViE\" target=\"_blank\" role=\"button\"><i data-feather='youtube'></i> Instalar SourceGuardian </a>";
                                            if ($ver_extensao_sg){
                                                $sim_nao_extensao = "<input type=\"hidden\" name=\"exsg\" id=\"exsg\" value=\"1\" /><span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row">Extensão SourceGuardian</th>
                                                <td><?php echo $sim_nao_extensao;?></td>
                                            </tr>
                                            <?php
                                            // ++++++++++++++++++++++++++ Extensao PHP - mbstring +++++++++++++++++++++++++++++
                                            $sim_nao_extensao = "<input type=\"hidden\" name=\"expg\" id=\"expg\" value=\"0\" /><span class=\"badge rounded-pill bg-danger\"> <i data-feather=\"slash\"></i> NÃO</span>";
                                            if ($ver_extensao_mbstring){
                                                $sim_nao_extensao = "<input type=\"hidden\" name=\"expg\" id=\"expg\" value=\"1\" /><span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row">Extensão mbstring</th>
                                                <td><?php echo $sim_nao_extensao;?></td>
                                            </tr>
                                            <?php
                                            // ++++++++++++++++++++++++++ Extensao PHP - PDO_PG +++++++++++++++++++++++++++++
                                            $sim_nao_extensao = "<input type=\"hidden\" name=\"expg\" id=\"expg\" value=\"0\" /><span class=\"badge rounded-pill bg-danger\"> <i data-feather=\"slash\"></i> NÃO</span>";
                                            if ($ver_extensao_pdo_pg){
                                                $sim_nao_extensao = "<input type=\"hidden\" name=\"expg\" id=\"expg\" value=\"1\" /><span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row">Extensão PDO_PG</th>
                                                <td><?php echo $sim_nao_extensao;?></td>
                                            </tr>
                                            <?php
                                            // ++++++++++++++++++++++++++ Extensao PHP - PDO_MY +++++++++++++++++++++++++++++
                                            $sim_nao_extensao = "<input type=\"hidden\" name=\"exmy\" id=\"exmy\" value=\"0\" /><span class=\"badge rounded-pill bg-danger\"> <i data-feather=\"slash\"></i> NÃO</span>";
                                            if ($ver_extensao_pdo_my){
                                                $sim_nao_extensao = "<input type=\"hidden\" name=\"exmy\" id=\"exmy\" value=\"1\" /><span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row">Extensão PDO_MySQL</th>
                                                <td><?php echo $sim_nao_extensao;?></td>
                                            </tr>
                                            <?php
                                            // ++++++++++++++++++++++++++ MySQL +++++++++++++++++++++++++++++
                                            $sim_nao_extensao = "<input type=\"hidden\" name=\"mysql\" id=\"mysql\" value=\"0\" /><span class=\"badge rounded-pill bg-warning\"> <i data-feather=\"slash\"></i> NÃO</span>";
                                            if ($ver_versao_mysql){
                                                $sim_nao_extensao = "<input type=\"hidden\" name=\"mysql\" id=\"mysql\" value=\"1\" /><span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row">MySQL
                                                    <small>
                                                        <span class="badge badge-light-primary">não impeditivo, pois pode haver um falso negativo</span>
                                                    </small>
                                                </th>
                                                <td><?php echo $sim_nao_extensao;?></td>
                                            </tr>
                                            <?php
                                            // ++++++++++++++++++++++++++ Internet +++++++++++++++++++++++++++++
                                            $sim_nao_extensao = "<span class=\"badge rounded-pill bg-warning\"> <i data-feather=\"slash\"></i> ?</span>";
                                            if ($ver_internet){
                                                $sim_nao_extensao = "<span class=\"badge rounded-pill bg-success\"> <i data-feather=\"check-circle\"></i> SIM</span>";
                                            }
                                            ?>
                                            <tr>
                                                <th scope="row">Acesso à internet
                                                    <small>
                                                        <span class="badge badge-light-primary">não impeditivo. Instalação OFFLINE oferece recursos limitados</span>
                                                    </small>
                                                </th>
                                                <td><?php echo $sim_nao_extensao;?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <?php
                                    if ($ver_internet){
                                        echo "<input type=\"hidden\" id=\"sinternet\" name=\"sinternet\" value=\"1\">";
                                    } else {
                                        echo "<input type=\"hidden\" id=\"sinternet\" name=\"sinternet\" value=\"0\">";
                                    }
                                    ?>
                                </form>
                                <div class="d-flex justify-content-between">
                                    <?php
                                    if ($ver_versao_php && $ver_extensao_sg && $ver_extensao_pdo_pg && $ver_extensao_pdo_my && $ver_extensao_mbstring){
                                        echo "
                                            <button class=\"btn btn-relief-primary btn-next\">
                                                <span class=\"align-middle d-sm-inline-block d-none\">Próximo</span> 
                                                <i data-feather=\"arrow-right\" class=\"align-middle ms-sm-25 ms-0\"></i>
                                            </button>
                                        ";
                                    }
                                    ?>
                                    O botão de "Próximo" só é habilitado se todas as condições estiverem confirmadas.
                                </div>
                            </div>
                            <!--
                            *****************************************************************************
                            PARTE 2 *********************************************************************
                            *****************************************************************************
                            -->
                            <div id="dados-pessoais" class="content" role="tabpanel" aria-labelledby="dados-pessoais-trigger">
                                <form enctype="multipart/form-data" id="form2" name="form2">
                                    <input type="hidden" name="estado" id="estado" value="" />
                                    <input type="hidden" name="cidade" id="cidade" value="" />
                                    <input type="hidden" name="idh" id="idh" value="<?php echo $idh;?>" />
                                    <div class="content-header">
                                        <h5 class="mb-0">Informe seu <span class="badge rounded-pill bg-primary">IDC</span></h5>
                                        <small>Adicione o IDC de cliente</small>
                                        <hr>
                                        <div class="mb-1 col-md-2">
                                            <input type="text" name="idc" id="idc" class="form-control text-primary" style="font-weight: bold;" />
                                        </div>
                                    </div>
                                    <div class="divider my-2">
                                        <div class="divider-text"><span class="badge rounded-pill bg-primary">Informações da colaboração</span></div>
                                    </div>
                                    <div class="row">
                                        <div class="mb-1 col-md-4">
                                            <label class="form-label" for="nome">Nome completo</label>
                                            <input type="text" name="nome" id="nome" class="form-control text-primary" style="font-weight: bold;" />
                                        </div>
                                        <div class="mb-1 col-md-2">
                                            <label class="form-label" for="cpf">CPF</label>
                                            <input type="text" name="cpf" id="cpf" class="form-control text-primary"
                                                style="font-weight: bold;" data-inputmask='"mask": "999.999.999-99"'
                                                data-mask />
                                        </div>
                                        <div class="mb-1 col-md-3">
                                            <label class="form-label" for="email">E-mail</label>
                                            <input type="text" name="email" id="email" class="form-control text-primary" style="font-weight: bold;" />
                                        </div>
                                        <div class="divider my-2">
                                            <div class="divider-text"><span class="badge rounded-pill bg-primary">Informações do Município</span></div>
                                        </div>
                                        <div class="mb-1 col-md-3">
                                            <label class="form-label" for="ibge">IBGE do município</label>
                                            <input type="text" name="ibge" id="ibge" class="form-control text-primary" style="font-weight: bold;" />
                                        </div>
                                        <div class="mb-1 col-md-2">
                                            <label class="form-label" for="cies">Município</label>
                                            <div class="text-primary align-self-center" id="cies" style="font-weight: bold;"></div>
                                        </div>
                                        <div class="mb-1 col-sm-2 align-self-center">
                                            <a class="btn btn-relief-primary"
                                                href="https://www.ibge.gov.br/explica/codigos-dos-municipios.php"
                                                target="_blank" role="button">IBGE</a>
                                        </div>
                                    </div>
                                </form>
                                <span class="badge badge-light-primary text-dark pb-1"><strong>LGPD! </strong> A Lei
                                    Geral de Proteção de Dados Pessoais (LGPD), Lei n°
                                    13.709/2018, todos os dados contidos aqui estão protegidos pelo Lei
                                    LGPD</span><br><br>
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-relief-primary btn-prev">
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Voltar</span>
                                    </button>
                                    <button class="btn btn-relief-primary btn-next" name="next2" id="next2">
                                        <span class="align-middle d-sm-inline-block d-none">Próximo</span>
                                        <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                                    </button>
                                </div>
                            </div>
                            <!--
                            *****************************************************************************
                            PARTE 3 *********************************************************************
                            *****************************************************************************
                            -->
                            <div id="contrato" class="content" role="tabpanel" aria-labelledby="contrato-trigger">
                                <form id="form3" name="form3">
                                    <div class="content-header">
                                        <h5 class="mb-0">Contrato de uso do software</h5>
                                    </div>
                                    <div class="row">
                                        <div class="form-floating">
                                            <textarea class="form-control text-primary"
                                                style="font-weight: bold; height: 300px" id="licenca"
                                                name="licenca"></textarea>
                                            <label for="licenca"></label>
                                            <br>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="aceite" name="aceite" checked>
                                                <label class="form-check-label" for="aceite">Li, compreendi e aceito os termos e condições de uso do software</label>
                                            </div>
                                            <br>
                                        </div>
                                    </div>
                                </form>
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-relief-primary btn-prev">
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Voltar</span>
                                    </button>
                                    <button class="btn btn-relief-primary btn-next" id="next3">
                                        <span class="align-middle d-sm-inline-block d-none">Próximo</span>
                                        <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                                    </button>
                                </div>
                            </div>
                            <!--
                            *****************************************************************************
                            PARTE 4 *********************************************************************
                            *****************************************************************************
                            -->
                            <div id="bancodedados" class="content" role="tabpanel" aria-labelledby="bancodedados-trigger">
                                <form id="form4" name="form4">
                                    <div class="content-header">
                                        <h5 class="mb-0">Banco de Dados Mysql</h5>
                                    </div>
                                    <div class="row">
                                        <div class="mb-1 col-md-3">
                                            <label class="form-label" for="dbhost">Host</label>
                                            <input type="text" id="dbhost" name="dbhost"
                                                class="form-control text-primary" style="font-weight: bold;"
                                                value="localhost" />
                                        </div>
                                        <div class="mb-1 col-md-2">
                                            <label class="form-label" for="dbporta">Porta</label>
                                            <input type="text" id="dbporta" name="dbporta"
                                                class="form-control text-primary" style="font-weight: bold;"
                                                value="3306" />
                                        </div>
                                        <div class="mb-1 col-md-3">
                                            <label class="form-label" for="dbbanco">Banco</label>
                                            <input type="text" id="dbbanco" name="dbbanco"
                                                class="form-control text-primary" style="font-weight: bold;"
                                                value="scsus<?php echo $sobre['vsisdb'];?>" />
                                        </div>

                                        <div class="mb-1 col-md-2">
                                            <label class="form-label" for="dbusuario">Usúario</label>
                                            <input type="text" id="dbusuario" name="dbusuario"
                                                class="form-control text-primary" style="font-weight: bold;"
                                                value="root" />
                                        </div>
                                        <div class="mb-1 col-md-2">
                                            <label class="form-label" for="dbsenha">Senha</label>
                                            <input type="password" id="dbsenha" name="dbsenha"
                                                class="form-control text-primary" style="font-weight: bold;"
                                                placeholder="" />
                                        </div>
                                    </div>
                                    <hr>
                                    <br>
                                    <div class="row">
                                        <div class="mb-1 col-md-12">
                                            <label for="adb">Banco de Dados</label>
                                            <div class="form-floating">
                                                <select class="select2 form-select" id="adb" name="adb" aria-label="Floating label select example">
                                                    <option value="0" selected>Criar novo banco de dados</option>
                                                    <option value="1">Utilizar banco existente (vazio)</option>
                                                    <option value="2">Utilizar banco existente (apagar conteúdo)
                                                    </option>
                                                </select>

                                            </div>

                                        </div>
                                        <hr class="gb-primary">
                                        <br>
                                        <button type="button" id="conexao" class="btn btn-relief-warning">Testar conexão</button>
                                    </div><br>
                                </form>
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-relief-primary btn-prev">
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Voltar</span>
                                    </button>
                                    <button class="btn btn-relief-primary btn-next" id="next4">
                                        <span class="align-middle d-sm-inline-block d-none">Próximo</span>
                                        <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                                    </button>
                                </div>
                            </div>
                            <!--
                            *****************************************************************************
                            PARTE 5 *********************************************************************
                            *****************************************************************************
                            -->
                            <div id="administrador" class="content" role="tabpanel" aria-labelledby="administrador-trigger">
                                <form id="form5" name="form5">
                                    <div class="content-header">
                                        <h5 class="mb-0">Administrador</h5>
                                    </div>
                                    <div class="row">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Etapa de Verificação Status</th>
                                                    <th scope="col"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <th scope="row">Etapa 1 - Requisitos</th>
                                                    <td>
                                                        <span class="badge rounded-pill bg-success">
                                                            <i class="fa fa-check-circle" aria-hidden="true"></i>
                                                            OK
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Etapa 2 - Dados Pessoais</th>
                                                    <td>
                                                        <div id="dadosInstMen1"></div>
                                                        <div id="dadosInstMen2"></div>
                                                        <span class="badge rounded-pill bg-success">
                                                            <i class="fa fa-check-circle" aria-hidden="true"></i>
                                                            OK
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Etapa 3 - Contrato Aceito</th>
                                                    <td>
                                                        <span class="badge rounded-pill bg-success">
                                                            <i class="fa fa-check-circle" aria-hidden="true"></i>
                                                            OK
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Etapa 4 - Instalação de Banco de Dados</th>
                                                    <td>
                                                        <div id="dbInstMen"></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Alterar a senha do Adminsitrador</th>
                                                    <td>
                                                        <div class="mb-1 col-md-3">
                                                            <input type="password" id="senha" name="senha" class="form-control text-primary" style="font-weight: bold;" onKeyUp="verificaForcaSenha();" />
                                                        </div>
                                                        <span id="password-status"></span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Confirmar a senha do Adminstrador</th>
                                                    <td>
                                                        <div class="mb-1 col-md-3">
                                                            <input type="password" id="senha2" name="senha2" class="form-control text-primary" style="font-weight: bold;" onKeyUp="verificaIgualSenha();" />
                                                        </div>
                                                        <span id="password-status2"></span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </form>
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-relief-primary btn-prev">
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Voltar</span>
                                    </button>
                                    <button class="btn btn-relief-primary btn-next" id="next5">
                                        <span class="align-middle d-sm-inline-block d-none">Próximo</span>
                                        <i data-feather="arrow-right" class="align-middle ms-sm-25 ms-0"></i>
                                    </button>
                                </div>    
                            </div>
                            <!--
                            *****************************************************************************
                            PARTE 6 *********************************************************************
                            *****************************************************************************
                            -->
                            <div id="final" class="content" role="tabpanel" aria-labelledby="final-trigger">
                                <form id="form6" name="form6">
                                    <div class="content-header">
                                        <h5 class="mb-0">Obrigado</h5>
                                    </div>
                                    <div class="row">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Ao clicar em "Finalizar instalação" você será redirecionado para a tela de login</th>
                                                    <th scope="col"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <th scope="row">Usuário: admin</th>
                                                    <td>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th scope="row">Senha: (definida no passo anterior)</th>
                                                    <td>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </form>
                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-relief-primary btn-prev">
                                        <i data-feather="arrow-left" class="align-middle me-sm-25 me-0"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Voltar</span>
                                    </button>
                                    <button class="btn btn-relief-success btn-submit" id="btfinal">Finalizar instalação</button>
                                </div>     
                            </div>
                            <!--
                            *****************************************************************************
                            FINAL ***********************************************************************
                            *****************************************************************************
                            -->
                        </div>
                    </div>
                </section>
                <!-- /Horizontal Wizard -->
            </div>
        </div>
    </div>

    <!-- END: Content-->
    <?php 
        require_once('rodape.php');
    ?>

    <script>
    // ********************************************************************************************************************************
    // ********************************************************************************************************************************
    // ********************************************************************************************************************************
    // ********************************************************************************************************************************
    $(document).ready(function() {
        $('[data-mask]').inputmask();
        if ($("#sinternet").val() == 1) {
            $("#idc").focusout(function() {
                $.get('vdados.php?idc=' + $(this).val(), function(data) {
                    if (data.includes(":")) {
                        const arDados = data.split(":");
                        if (arDados[0] > 0) {
                            $("#nome").val(arDados[1]);
                            $("#cpf").val(arDados[2]);
                            $("#email").val(arDados[3]);
                        }
                    }
                });
                return false;
            });
            $("#ibge").focusout(function() {
                $.get('vibge.php?ibge=' + $(this).val(), function(data) {
                    if (data.includes(":")) {
                        const arDados = data.split(":");
                        if (arDados[0] > 0) {
                            $("#cidade").val(arDados[2]);
                            $("#estado").val(arDados[5]);
                            $("#cies").html(arDados[2] + ' - ' + arDados[5]);
                        }
                    }
                });
                return false;
            });

        }
        $("#conexao").click(function() {
            $.get('conecta.php?ap=t&host=' + $("#dbhost").val() + '&porta=' + $("#dbporta").val() +
                '&usuario=' + $("#dbusuario").val() + '&senha=' + encodeURIComponent($("#dbsenha").val()),
                function(data) {
                    var alert_tt = "Conexão!";
                    var alert_tp = "success";
                    if (data.includes(":")) {
                        alert_tt = "Conexão!";
                        alert_tp = "error";
                    }
                    Swal.fire(
                        alert_tt,
                        data,
                        alert_tp
                    )
                });
        });

    });
    function verificaForcaSenha() {
        var numeros = /([0-9])/;
        var alfabeto = /([a-zA-Z])/;
        var chEspeciais = /([~,!,@,#,$,%,^,&,*,-,_,+,=,?,>,<])/;
        if ($('#senha').val().length < 6) {
            $('#password-status').html("<span style='color:red'>Fraco, insira no mínimo 6 caracteres</span>");
        } else {
            if ($('#senha').val().match(numeros) && $('#senha').val().match(alfabeto) && $('#senha').val()
                .match(chEspeciais)) {
                $('#password-status').html("<span style='color:green'><b>Forte</b></span>");
            } else {
                $('#password-status').html("<span style='color:orange'>Médio, insira um caracter especial</span>");
            }
        }
    }
    // ********************************************************************************************************************************
    // ********************************************************************************************************************************
    // ********************************************************************************************************************************
    // ********************************************************************************************************************************
    </script>

</body>
<!-- END: Body-->

</html>
