<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$msng = isset($_GET["msng"]) ? trim($_GET["msng"]) : '';

$dti = date('Ym').'01';
$dtf = date('Ym').udia(date('m'),date('Y'));
$sigtap = 'S';
$compano = date('Y');
$compmes = date('m');
$cnes = "";
$ine = "";
$cbo = "";
$procs = "";
$nsec = "";
$cnpj = "";
$faturado = "";

$rs = $con->prepare("SELECT * FROM bpa_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$dti = $row->dti;
			$dtf = $row->dtf;
			$sigtap = $row->sigtap;
			$compano = $row->compano;
			$compmes = $row->compmes;
      $cnes = $row->cnes;
      $ine = $row->ine;
      $cbo = $row->cbo;
      $procs = $row->procs;
      $nsec = $row->nsec;
      $cnpj = $row->cnpj;
      $faturado = $row->faturado;
		}
	}
}
?>
<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Configurações do BPA para exportação e-SUS</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">BPA</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                    <div class="row g-1 mb-md-1">
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="nsec">Nome secretaria</label>
                            <input type="text" class="form-control" name="nsec" id="nsec" value="<?php echo $nsec;?>" /><br>
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="cnpj">CNPJ (Apenas números)</label>
                            <input type="text" class="form-control" name="cnpj" id="cnpj" value="<?php echo $cnpj;?>" data-inputmask='"mask": "99999999999999"' data-mask /><br>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="dtif">[1] Data de Inicio e Data de Fim (período)</label>
                                <input type="text" class="form-control float-right" name="dtif" id="dtif" />
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">[2A] Mês da competência</label>
                                <select class="form-select" aria-label="Default select example" name="compmes" id="compmes">
                                  <option value="100">Considerar mês da data inicial do período indicado em [1]</option>
                                  <option value="200">Considerar mês da data final do período indicadoem [1]</option>
                                <?php
                                  for ($i=1;$i<13;$i++){
                                    $sele = '';
                                    if ($compmes == $i){
                                      $sele = 'selected';
                                    }
                                    echo "<option value=\"".$i."\" ".$sele.">".$i."</option>";
                                  }
                                ?>
				                        </select>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">[2B] Ano da competência</label>
                                <select class="form-select" aria-label="Default select example" name="compano" id="compano">
                                  <option value="100">Considerar ano da data inicial do período indicado em [1]</option>
                                  <option value="200">Considerar ano da data final do período indicado em [1]</option>
                                <?php
                                  for ($i=date('Y');$i>(date('Y')-6);$i--){
                                    $sele = '';
                                    if ($compano == $i){
                                      $sele = 'selected';
                                    }
                                    echo "<option value=\"".$i."\" ".$sele.">".$i."</option>";
                                  }
                                ?>
				                        </select>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">No instante da geração, considerar:</label>
                                <select class="form-select" aria-label="Default select example" name="cons" id="cons">
                                  <option value="" selected>-- Escolha --</option>
                                  <option value="1">Mês e ano completo da competência indicada em [2A][2B]</option>
                                  <option value="2">Período indicado em [1]</option>
				                        </select>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-4 col-12">
                            <div class="mb-1">
                                <label class="form-label">[PEC] Apenas procedimentos SIGTAP</label>
                                <select class="form-select" aria-label="Default select example" name="sigtap" id="sigtap">
                                <?php
                                  if ($sigtap == 'S'){
                                    echo "
                                      <option value=\"S\" selected>Sim</option>
                                      <option value=\"N\">Não</option>
                                    ";
                                  } else {
                                    echo "
                                      <option value=\"S\">Sim</option>
                                      <option value=\"N\" selected>Não</option>
                                    ";
                                  }
                                ?>
				                        </select>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-4 col-12">
                            <div class="mb-1">
                                <label class="form-label">[ +Gestor Saúde] Considerar já faturados</label>
                                <select class="form-select" aria-label="Default select example" name="faturado" id="faturado">
                                <?php
                                  if ($faturado == 'S'){
                                    echo "
                                      <option value=\"S\" selected>Sim</option>
                                      <option value=\"N\">Não</option>
                                    ";
                                  } else {
                                    echo "
                                      <option value=\"S\">Sim</option>
                                      <option value=\"N\" selected>Não</option>
                                    ";
                                  }
                                ?>
				                        </select>
                            </div>
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="cnes">[PEC] Filtro de CNES (se maior que 1, separe por vírgula)</label>
				                    <input type="text" class="form-control" name="cnes" id="cnes" value="<?php echo $cnes;?>">
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="ine">[PEC] Filtro de INE (se maior que 1, separe por vírgula)</label>
                            <input type="text" class="form-control" name="ine" id="ine" value="<?php echo $ine;?>" />
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="cbo">[PEC] Filtro de CBO (se maior que 1, separe por vírgula)</label>
                            <input type="text" class="form-control" name="cbo" id="cbo" value="<?php echo $cbo;?>" />
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="procs">[PEC] Filtro de Procedimentos (se maior que 1, separe por vírgula)</label>
                            <input type="text" class="form-control" name="procs" id="procs" value="<?php echo $procs;?>" /><br>
                        </div>
                        <button type="submit" class="btn btn-primary" id="button-addon2">Gravar</button>
                    </div>
                  </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Basic Inputs end -->
<?php
include('info.php');
if (isset($mod_serv_video_1)){
  if (strlen($mod_serv_video_1) > 0){
    echo "<a href=\"".$mod_serv_video_1."\" target=\"_blank\"><i class=\"fa fa-film text-danger\"></i></a> Vídeo<br>";
  }
}
if (file_exists('leiame.txt')){
  echo "<a href=\"mod/bpa/leiame.txt\" target=\"_blank\"><i class=\"fa fa-info-circle text-primary\"></i></a> Leia-me para mais informações<br>";
}
echo "<br>";
?>
<script>
$(function () {

  $('[data-mask]').inputmask();

  <?php
  if (strlen($msng) > 0){
    echo "
      toastr['warning'](
        '".$msng."',
        'Não foi possível iniciar a geração do BPA',        
        {
          closeButton: true,
          debug: false,
          newestOnTop: false,
          progressBar: false,
          positionClass: \"toast-top-right\",
          preventDuplicates: false,
          tapToDismiss: true,
          onclick: null,
          showDuration: \"30000\",
          hideDuration: \"10000\",
          timeOut: \"50000\",
          extendedTimeOut: \"10000\",
          showEasing: \"swing\",
          hideEasing: \"linear\",
          showMethod: \"fadeIn\",
          hideMethod: \"fadeOut\"
        }
      );
    ";
  }
  ?>

  $('#dtif').daterangepicker({
	  startDate: '<?php echo datanas6($dti);?>',
	  endDate: '<?php echo datanas6($dtf);?>',
      locale: {
        format: 'DD/MM/YYYY'
      }
  });

  $('#frm').validate({
    submitHandler: function (form) {
      $.post('mod/bpa/gv_cf.php', $('#frm').serialize(), function (data, textStatus) {
        if (data == 'Ok'){ // data.substring(0,2)
          swal.fire('Ok!','Gravado com sucesso!','success');
        } else {
          swal.fire('erro!',data,'error');
        }
      });
    },
    rules: {
      cons: {
        required: true
      },
      nsec: {
        required: true
      },
      cnpj: {
        required: true
      }
    },
    messages: {
      cons: {
        required: "Este campo é necessário"
      },
      nsec: {
        required: "Este campo é necessário"
      },
      cnpj: {
        required: "Este campo é necessário"
      }
    }
  });

});
SlickLoader.disable();
</script>