<?php
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//    
//    
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$tabela = 'tb_dim_imunobiologico';
$condicao = "st_registro_valido = 1";
$campo = array();
$campo[0][0] = 'nu_identificador';	$campo[0][1] = 'Codigo';
$campo[1][0] = 'sg_imunobiologico';	$campo[1][1] = 'Sigla';
$campo[2][0] = 'no_imunobiologico';	$campo[2][1] = 'Nome';

$SQL_1 = "
	SELECT 
		a.nu_cns,
		a.nu_cpf as nu_cpf_cidadao,
		a.no_cidadao,
		a.dt_nascimento,
		a.no_mae,
		a.no_pai,
		a.co_seq_cidadao,
		a.dt_atualizado,
		a.st_unificado
	FROM
		tb_cidadao AS a 
	INNER JOIN (
		SELECT 
			no_cidadao, 
			dt_nascimento, 
			count(*) 
		FROM 
			tb_cidadao 
		WHERE
			st_faleceu = 0 AND
			st_ativo = 1 AND
			st_unificado = 0
		GROUP BY 
			no_cidadao, 
			dt_nascimento 
		HAVING count(*) > 1
	) AS b 
	ON 
		a.no_cidadao = b.no_cidadao AND a.dt_nascimento = b.dt_nascimento
	ORDER BY a.no_cidadao
";

?>
                <div class="row">
                    <div class="col-12">
                        <p>Lista de usuários duplicados</p>
                    </div>
                </div>

                <!-- Basic table -->
                <section id="basic-datatable">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <table id="tbl1" class="datatables-basic table">
                                <thead>
                                    <tr>
                                        <th>CNS</th>
                                        <th>CPF</th>
                                        <th>Nome</th>
                                        <th>Data nascimento</th>
                                        <th>Mãe</th>
                                        <th>Pai</th>
                                        <th>CS</th>
                                        <th>MA</th>
                                        <th>CNES</th>
                                        <th>INE</th>
                                        <th>DTAT</th>
                                        <th>UN</th>
                                    </tr>
                                </thead>
                                <tbody>
<?php

require_once('../../class/_cidadao.class.php');
$rs = $cdb->query($SQL_1);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
            $cc = 0;
            if (strlen(trim($row->nu_cns)) == 15){
                $cc = trim($row->nu_cns);
            }
            if (strlen(trim($row->nu_cpf_cidadao)) == 11){
                $cc = trim($row->nu_cpf_cidadao);
            }

            $bc_ma = "";
            $bc_ine = "";
            $bc_equipe = "";
            $bc_cnes = "";
            $bc_unidade = "";
            $bc_prof_nome = "";
            $bc_prof_cns = "";
            $cid = new Cidadao($cdb, $row->nu_cns, $row->nu_cpf_cidadao, null, null, '', '', '');
            if ($cid->ok){
                $bc_ma = $cid->ma;
                $bc_ine = $cid->ine;
                $bc_equipe = $cid->equipe;
                $bc_cnes = $cid->cnes;
                $bc_unidade = $cid->unidadeSaude;
                $bc_prof_nome = $cid->nomeProfissional;
                $bc_prof_cns = $cid->cnsProfissional;
            }

            $unificado = ($row->st_unificado == 1) ? "<span class=\"badge bg-danger\">Sim</span>" : "<span class=\"badge bg-success\">Não</span>";
            $data_cad = $row->dt_atualizado;
            if (strlen($data_cad) == 19){
                $data_cad = ftimes($data_cad,'ADFB');
            }
            
            $show_dup_cns = $row->nu_cns;
            $show_dup_cpf = $row->nu_cpf_cidadao;
            $show_dup_nome = $row->no_cidadao;
            $show_dup_mae = $row->no_mae;
            $show_dup_pai = $row->no_pai;
            $show_dup_dtnas = datanas2($row->dt_nascimento);
            if ($scsus_demo){
                $show_dup_cns = "***************";
                $show_dup_cpf = "***.***.***-**";
                $show_dup_nome = "******* ********** *********";
                $show_dup_mae = "********** **** *********";
                $show_dup_pai = "****** ********** *****";
                $show_dup_dtnas = "**/**/****";
            }

			echo "
            <tr>
                <td>".$show_dup_cns."</td>
                <td>".$show_dup_cpf."</td>
                <td>".$show_dup_nome."</td>
                <td><a href=\"#\" onclick=\"$('.content-body').load('mod/cidadao/cidadao.php?drt=1&cc=".$cc."');\"><i class=\"fas fa-portrait\"></i></a>&nbsp;&nbsp;".$show_dup_dtnas."</td>
                <td>".$show_dup_mae."</td>
                <td>".$show_dup_pai."</td>
                <td>".$row->co_seq_cidadao."</td>

                <td>".$bc_ma."</td>
                <td>".$bc_cnes."</td>
                <td>".$bc_ine."</td>

                <td>".$data_cad."</td>
                <td>".$unificado."</td>
            </tr>
            ";
		}
	}
}
/*
$run_s1 = pg_query($cdb,"SELECT ".$soma_campos." FROM ".$tabela." WHERE ".$condicao);
$nm_sql_1 = 0;
$nm_sql_1 = pg_num_rows($run_s1);
if ($nm_sql_1 > 0){
	while ($result1 = pg_fetch_array($run_s1)){
		echo "<tr>";
			for ($i=0;$i<count($campo);$i++){
				echo "<td>".$result1[$campo[$i][0]]."</td>";
			}
		echo "</tr>";
	}
}
*/

?>
                                </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    </section>
                <!--/ Basic table -->

<!-- Page specific script -->
<script>
    $(document).ready(function() {
        var groupColumn = 2;
        $('#tbl1').DataTable({







            columnDefs: [{ visible: false, targets: groupColumn }],
            order: [[groupColumn, 'asc']],
            displayLength: 25,
            drawCallback: function (settings) {
                var api = this.api();
                var rows = api.rows({ page: 'current' }).nodes();
                var last = null;
                api
                    .column(groupColumn, { page: 'current' })
                    .data()
                    .each(function (group, i) {
                        if (last !== group) {
                            $(rows)
                                .eq(i)
                                .before('<tr class="group"><td colspan="11">' + group + '</td></tr>');
    
                            last = group;
                        }
                    });
            },














            dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-4"l><"col-sm-12 col-md-4"B><"col-sm-12 col-md-4"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
            buttons: [
              'copyHtml5',
              'excelHtml5',
              {
                extend: 'csvHtml5',
                text: 'CSV',
                fieldBoundary: '',
                fieldSeparator: ';'
              },
              'print'
            ],
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            }
        });
    });
</script>