<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Compara</h4>
                </div>
                <div class="card-body mt-2">
                    <p class="card-text">
                        Executado em: <?php echo date('d/m/Y H:i:s');?>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$dados = isset($_GET["dados"]) ? trim($_GET["dados"]) : '';
$tipo = isset($_GET["tipo"]) ? trim($_GET["tipo"]) : '';
$tabela = isset($_GET["tabela"]) ? trim($_GET["tabela"]) : '';
$contador = 1;
if (strlen($tabela) > 3){

    echo "Tabela selecionada: ".$tabela."<br>";
    $campo_cpf = "";
    $campo_sequencial = "";
    if ($tabela == 'tb_cidadao'){
        $campo_cpf = "nu_cpf";
        $campo_sequencial = "co_seq_cidadao";
    }
    if ($tabela == 'tb_fat_cad_individual'){
        $campo_cpf = "nu_cpf_cidadao";
        $campo_sequencial = "co_seq_fat_cad_individual";
    }

    
    if ($tipo == 'S'){
        $show_tipo = "SISAB (".$dados.") >>>> e-SUS (".$tabela.")";
        $show_local = $tabela;
    } else {
        $show_tipo = "e-SUS (".$tabela.") >>>> SISAB (".$dados.")";
        $show_local = $dados;
    }


    $processar = false;
    if ($tipo == 'S'){
        $rs = $con->prepare("SELECT cpf, cns FROM ".$dados." WHERE id = ? AND ibge = ?");
        $rs->bindParam(1,$_SESSION['login']);
        $rs->bindParam(2,$_SESSION['ibge']);
        if($rs->execute()){
            if($rs->rowCount() > 0){
                $processar = true;
                echo "
                    <table id=\"tbdt\" class=\"table table-striped\">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>#</th>
                            <th>CPF</th>
                            <th>CNS</th>
                            <th>Tipo</th>
                            <th>CPF</th>
                            <th>CNS</th>
                            <th>Resultado</th>
                        </tr>
                    </thead>
                    <tbody>
                ";
            }
        }
    } else {
        $rs = $cdb->prepare("SELECT ".$campo_cpf." as cpf, nu_cns as cns FROM ".$tabela);
        if($rs->execute()){
            if($rs->rowCount() > 0){
                $processar = true;
                echo "
                    <table id=\"tbdt\" class=\"table table-striped\">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>#</th>
                            <th>CPF</th>
                            <th>CNS</th>
                            <th>Tipo</th>
                            <th>CPF</th>
                            <th>CNS</th>
                            <th>Resultado</th>
                        </tr>
                    </thead>
                    <tbody>
                ";
            }
        }
    }
    if ($processar){
        while($row = $rs->fetch(PDO::FETCH_OBJ)){
            $cns = $row->cns;
            $cpf = $row->cpf;

            $show_demo_cpf = $cpf;
            $show_demo_cns = $cns;
            if ($scsus_demo){
                $show_demo_cpf = "***.***.***-**";
                $show_demo_cns = "***************";
            }

            if ($tipo == 'S'){
                $wbusca = $campo_cpf." = '".$cpf."' OR nu_cns = '".$cns."'";
                $rs_busca = $cdb->prepare("SELECT ".$campo_cpf." as cpf, nu_cns as cns FROM ".$tabela." WHERE ".$wbusca);
            } else {
                $wbusca = "(cpf = '".$cpf."' OR cns = '".$cns."')";
                $rs_busca = $con->prepare("SELECT cpf, cns FROM ".$dados." WHERE id = ? AND ibge = ? AND ".$wbusca);
                $rs_busca->bindParam(1,$_SESSION['login']);
                $rs_busca->bindParam(2,$_SESSION['ibge']);
            }
            if($rs_busca->execute()){
                if($rs_busca->rowCount() > 0){
                    while($row_busca = $rs_busca->fetch(PDO::FETCH_OBJ)){
                        $comp_cpf = "(CPF !=)";
                        $show_cpf = "<span class=\"badge bg-warning\">".$show_demo_cpf."</span>";
                        if ($cpf == $row_busca->cpf){
                            $show_cpf = "<span class=\"badge bg-success\">".$show_demo_cpf."</span>";
                            $comp_cpf = "(CPF ==)";
                        }
                        $show_cns = "<span class=\"badge bg-warning\">".$show_demo_cns."</span>";
                        $comp_cns = "CNS !=";
                        if ($cns == $row_busca->cns){
                            $show_cns = "<span class=\"badge bg-success\">".$show_demo_cns."</span>";
                            $comp_cns = "CNS ==";
                        }

                        $show_demo_cpf_2 = $row_busca->cpf;
                        $show_demo_cns_2 = $row_busca->cns;
                        if ($scsus_demo){
                            $show_demo_cpf_2 = "***.***.***-**";
                            $show_demo_cns_2 = "***************";
                        }

                        echo "
                            <tr>
                                <td>".$contador."</td>
                                <td><i class=\"fas fa-check-square text-success\" title=\"Ok\"></i></td>
                                <td>".$show_cpf."</td>
                                <td>".$show_cns."</td>
                                <td>".$show_tipo."</td>
                                <td>".$show_demo_cpf_2."</td>
                                <td>".$show_demo_cns_2."</td>
                                <td>Encontrado [".$comp_cpf." / ".$comp_cns."]</td>
                            </tr>
                        ";
                    }
                } else {
                    echo "
                    <tr>
                        <td>".$contador."</td>
                        <td><i class=\"fas fa-circle text-danger\"></i></td>
                        <td>".$show_demo_cpf."</td>
                        <td>".$show_demo_cns."</td>
                        <td>".$show_tipo."</td>
                        <td>-</td>
                        <td>-</td>
                        <td>Cidadão não encontrado em ".$show_local."</td>
                    </tr>
                ";
                }
            }
            $contador++;
        }
        echo "
            </tbody>
            </table>
        ";
    }
} else {
    echo "<br><br>Nenhum tabela selecionada, não vai processar nada<br><br>";
}


?>
<script>
    SlickLoader.disable();
    $(document).ready(function() {
        $('#tbdt').DataTable({
            responsive: true,
            lengthChange: true, 
            orderCellsTop: true,
            autoWidth: false,
            language: {
                lengthMenu: 'Mostrando _MENU_ registros por página',
                zeroRecords: 'Nenhum encontrado - Desculpe',
                info: 'Mostrando página _PAGE_ de _PAGES_',
                infoEmpty: 'Nenhum registro encontrado',
                infoFiltered: '(filtrando por _MAX_ de um total de registros)',
                search: 'Busca',
                decimal: ',',
                thousands: '.',
                paginate: {
                  previous: '&nbsp;',
                  next: '&nbsp;'
                }
            },
            dom: 'Bfrtip',
            buttons: [
                'excelHtml5',
                'csvHtml5'
            ]
        });
    });
</script>