<?php
require_once('../../core/functions.php');
require_once('../../core/sp.php');
require_once('../../cfg/mydb.php');
require_once('../../core/con_my.php');

include('parametros.php');

$titulo = "";
$descricao = "";
$logo = "img/logo.png";
$id_kiosk = 0;

$tk = isset($_GET["tk"]) ? trim($_GET["tk"]) : '';
if (strlen($tk) > 10){
    $rs = $con->prepare("SELECT * FROM kiosk_tb_kiosk WHERE token = ? LIMIT 1");
    $rs->bindParam(1,$tk);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $titulo = $row->titulo;
                $descricao = $row->descricao;
                $id_kiosk = $row->idg;
                if (strlen($row->logo) > 0){
                    $logo = $row->logo;
                }
            }
        }
    }
}



if (strlen($titulo) > 0){
?>
<div class="card">
    <table>
        <tr>
            <td>
                <div class="card-body">
                    <p class="card-text text-center">
                        <img src="<?php echo $logo;?>" width="180" height="180" />
                    </p>
                </div>
            </td>
            <td>
                <div class="card-header">
                    <h4 class="card-title"><?php echo $titulo;?></h4>
                </div>
                <div class="card-body">
                    <p class="card-text">
                        <?php echo $descricao;?>
                    </p>
                </div>
            </td>
        </tr>
    </table>
</div>
<?php }?>


<div class="card">
    <div class="card-header">
        <h4 class="card-title">Serviços</h4>
    </div>
    <div class="card-body">
        <div class="row">

            <?php
                if ($id_kiosk > 0){
                    for ($i=0;$i<count($servicos);$i++){
                        $mostrar = false;
                        $rs = $con->prepare("SELECT * FROM kiosk_tb_servicos WHERE id_kiosk = ? AND id_servico = ? LIMIT 1");
                        $rs->bindParam(1,$id_kiosk);
                        $rs->bindParam(2,$servicos[$i]['id']);
                        if($rs->execute()){
                            if($rs->rowCount() > 0){
                                $mostrar = true;
                            }
                        }
                        if ($mostrar){
                            /*
                            echo "
                                <div class=\"col-md-6 col-xl-6\">
                                    <div class=\"card bg-".$servicos[$i]['cor']." text-white\">
                                        <div class=\"card-body\">
                                            <h4 class=\"card-title text-white\">".$servicos[$i]['desc']."</h4>
                                            <p class=\"card-text\">
                                                <a href=\"#\" onclick=\"$('#esquerda').load('".$servicos[$i]['url']."');\" class=\"btn btn-icon btn-icon rounded-circle btn-primary\" aria-disabled=\"true\">
                                                    <i data-feather=\"message-square\"></i>
                                                </a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            ";
                            */
                            echo "
                                <div class=\"col-md-6 col-xl-6\">
                                    <div class=\"card bg-".$servicos[$i]['cor']." text-white\">
                                        <a href=\"#\" onclick=\"$('.content-body').load('".$servicos[$i]['url']."&tk=".$tk."');\">
                                            <div class=\"card-body\">
                                                <h2 class=\"fw-bolder text-white text-end\">".$servicos[$i]['desc']."</2>
                                                <div class=\"avatar bg-light-white avatar-xl\">
                                                    <span class=\"avatar-content\">".$servicos[$i]['id']."</span>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            ";
                        }
                    }
                }
            ?>


        </div>
    </div>
</div>

<script>
    $(function () {

        if (feather) {
            feather.replace({
                width: 14,
                height: 14
            });
        }
        
    });
</script>
