<?php
require_once('../../core/functions.php');
require_once('../../core/sp.php');

$tk = isset($_GET["tk"]) ? trim($_GET["tk"]) : '';
$sv = isset($_GET["sv"]) ? trim($_GET["sv"]) : '';

?>
<div class="auth-wrapper auth-v1 px-2">
    <div class="auth-inner py-2">
        <!-- Login v1 -->
        <div class="card mb-0">
            <div class="card-body">
                <span class="brand-logo">
                    <img src="../../app-assets/images/logo/logo-es1.png" alt="">
                </span>
                <h2 class="brand-text mb-0">Autoserviço</h2>
                <p class="card-text mb-2">É necessário se identificar para continuar</p>
                <form class="auth-login-form mt-2" action="javascript:void(0);" id="frmlogin" name="frmlogin" method="POST">
                    <input type="hidden" id="tk" name="tk" value="<?php echo $tk;?>">
                    <input type="hidden" id="sv" name="sv" value="<?php echo $sv;?>">
                    <div class="mb-1">
                        <label for="cpf" class="form-label">CPF</label>
                        <input type="text" class="form-control" id="cpf" name="cpf" tabindex="1" autofocus data-inputmask='"mask": "999.999.999-99"' data-mask />
                    </div>
                    <div class="divider my-2">
                        <div class="divider-text">ou</div>
                    </div>
                    <div class="mb-1">
                        <label for="cpf" class="form-label">CNS</label>
                        <input type="text" class="form-control" id="cns" name="cns" tabindex="2" value="707005838930634" data-inputmask='"mask": "999999999999999"' data-mask />
                    </div>
                    <div class="divider my-2">
                        <div class="divider-text">preencha também</div>
                    </div>
                    <div class="mb-1">
                        <label for="datanas" class="form-label">Data de nascimento</label>
                        <input type="text" class="form-control" id="datanas" name="datanas" value="11/07/2018" tabindex="3" data-inputmask='"mask": "99/99/9999"' data-mask />
                    </div>
                    <div class="mb-1">
                        <button class="btn btn-primary w-100" tabindex="4" id="btlogin" name="btlogin">Seguir</button>
                    </div>
                </form>
                <a href="#" onclick="$('.content-body').load('main.php?tk=<?php echo $tk;?>');" class="btn btn-success w-100" role="button">Voltar aos serviços</a>
            </div>
        </div>
        <!-- /Login v1 -->
    </div>
</div>

<script>
  $(function () {
    $('[data-mask]').inputmask();

    if (feather) {
      feather.replace({
          width: 14,
          height: 14
      });
    }

    function validaCPF(cpf){
        cpf = cpf.replace(/\D/g, '');
        if(cpf.toString().length != 11 || /^(\d)\1{10}$/.test(cpf)) return false;
        var result = true;
        [9,10].forEach(function(j){
            var soma = 0, r;
            cpf.split(/(?=)/).splice(0,j).forEach(function(e, i){
                soma += parseInt(e) * ((j+2)-(i+1));
            });
            r = soma % 11;
            r = (r <2)?0:11-r;
            if(r != cpf.substring(j, j+1)) result = false;
        });
        return result;
    }

    function validaData(valor) {
        if (typeof valor !== 'string') {
            return false
        }
        if (!/^\d{2}\/\d{2}\/\d{4}$/.test(valor)) {
            return false
        }
        const partesData = valor.split('/')
        const data = { 
            dia: partesData[0], 
            mes: partesData[1], 
            ano: partesData[2] 
        }
        const dia = parseInt(data.dia)
        const mes = parseInt(data.mes)
        const ano = parseInt(data.ano)
        const diasNoMes = [ 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ]
        if (ano % 400 === 0 || ano % 4 === 0 && ano % 100 !== 0) {
            diasNoMes[2] = 29
        }
        if (mes < 1 || mes > 12 || dia < 1) {
            return false
        }
        else if (dia > diasNoMes[mes]) {
            return false
        }
        return true
    }

    function validaCNS(cns) {
        var validaTamanho = cns.length == 15;
        var validaInicio = ['1', '2', '7', '8', '9'].includes(cns[0]);

        if(validaTamanho && validaInicio){
            //CNS Iniciados em 7, 8 ou 9
            if(['7', '8', '9'].includes(cns[0])) {
                var soma = cns.split('').reduce((total, value, index) => total + (value * (15 - index)), 0);
                return soma % 11 == 0;
            } else {
                //CNS Iniciados em 1, 2
                var pis = cns.substring(0,11);
                var soma = pis.split('').reduce((total, value, index) => total + (value * (15 - index)), 0);

                var resto = soma % 11;
                var dv = resto == 0 ? 0 : 11 - resto;

                var resultado = dv == 10 ? `${pis}001${(11 - ((soma + 2) % 11))}` : `${pis}000${dv}`
                return resultado == cns;
            }
        }
        return false;
    }


    $("#btlogin").click(function() {
        var cpf = $("#cpf").val();
        cpf = cpf.replace(/-| |\.|\/|_/gi, "");
        var cns = $("#cns").val();
        cns = cns.replace(/_/gi, "");
        var datanas = $("#datanas").val();
        datanas = datanas.replace(/_/gi, "");


        if (cpf.length == 11){
            if (validaCPF(cpf)){
                if (validaData(datanas)){
                    $.post('check.php', $('#frmlogin').serialize(), function (data, textStatus) {
                        if (data == 'Ok'){ // data.substring(0,4)
                            $('.content-body').load('pri.php');
                        } else {
                            swal.fire('erro!',data,'error');
                        }
                    });
                } else {
                    swal.fire('Erro!','A data de nascimento informada é inválida','error');
                }
            } else {
                swal.fire('Erro!','O CPF informado não é válido','error');
            }
        } else {
            if (cns.length == 15){
                if (validaCNS(cns)){
                    if (validaData(datanas)){
                        $.post('check.php', $('#frmlogin').serialize(), function (data, textStatus) {
                            if (data == 'Ok'){ // data.substring(0,4)
                                $('.content-body').load('pri.php');
                            } else {
                                swal.fire('erro!',data,'error');
                            }
                        });
                    } else {
                        swal.fire('Erro!','A data de nascimento informada é inválida','error');
                    }
                } else {
                    swal.fire('Erro!','O CNS informado não é válido','error');
                }
            } else {
                swal.fire('Erro!','É necessário informar ou o CPF ou o CNS','error');
            }
        }




    });

  });
</script>