<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$idg = isset($_GET["idg"]) ? trim($_GET["idg"]) : 0;

$nome = '';
$cor_borda = '';
$cor_fundo = '';
$opacidade = 0;
$ativo = 0;
$raio = 0;
$descricao = '';

if ($idg > 0){
    $rs = $con->prepare("SELECT * FROM maps_tb_focos WHERE id = ? AND ibge = ? AND idg = ? LIMIT 1");
    $rs->bindParam(1,$_SESSION['login']);
    $rs->bindParam(2,$_SESSION['ibge']);
    $rs->bindParam(3,$idg);
    if($rs->execute()){
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $nome = $row->nome;
                $cor_borda = $row->cor_borda;
                $cor_fundo = $row->cor_fundo;
                $opacidade = $row->opacidade;
                $ativo = $row->ativo;
                $raio = $row->raio;
                $descricao = $row->descricao;
            }
        }
    }
}


?>

<form class="dt_adv_search" name="frm-foco" id="frm-foco" method="POST">
    <input type="hidden" id="idg" name="idg" value="<?php echo $idg;?>">
    <label>Nome: </label>
    <div class="mb-1">
        <input type="text" placeholder="Nome do foco" name="nome" id="nome" class="form-control" value="<?php echo $nome;?>" />
    </div>
    <label>Cor da borda: </label>
    <div class="mb-1">
        <input type="color" name="corborda" id="corborda" class="form-control" value="<?php echo $cor_borda;?>" />
    </div>
    <label>Cor de fundo: </label>
    <div class="mb-1">
        <input type="color" name="corfundo" id="corfundo" class="form-control" value="<?php echo $cor_fundo;?>" />
    </div>
    <label>Opacidade: </label>
    <div class="mb-1">
        <input type="number" name="opacidade" id="opacidade" class="form-control" value="<?php echo $opacidade;?>" />
    </div>
    <label>Raio: </label>
    <div class="mb-1">
        <input type="number" name="raio" id="raio" class="form-control" value="<?php echo $raio;?>" />
    </div>
    <label>Descrição: </label>
    <div class="mb-1">
        <input type="text" name="descricao" id="descricao" class="form-control" value="<?php echo $descricao;?>" />
    </div>
    <label>Situação: </label>
    <div class="mb-1">
        <select class="form-select" name="ativo" id="ativo">
            <?php
                if ($ativo == 1){
                    echo "
                        <option value=\"1\" selected>Ativo</option>
                        <option value=\"0\">Inativo</option>
                    ";
                } else {
                    echo "
                        <option value=\"1\">Ativo</option>
                        <option value=\"0\" selected>Inativo</option>
                    "; 
                }
            ?>
        </select>
    </div>
    <button type="submit" class="btn btn-primary">Gravar</button>
</form>

<script>
$(function () {
  $('#frm-foco').validate({
    submitHandler: function (form) {
        $.post('mod/maps/gv_ed_foco.php', $('#frm-foco').serialize(), function (data, textStatus) {
            if (data == 'Ok'){ // data.substring(0,2)
                swal.fire('Ok!','Gravado com sucesso!','success');
                //$('.content-body').load('mod/maps/mas.php');
            } else {
                swal.fire('erro!',data,'error');
            }
        });
    },
    rules: {
        opacidade: {
          required: true,
          number:true
        },
        raio: {
          required: true,
          number:true
        },
        nome: {
          required: true
        },
    },
    messages: {
        opacidade: {
          required: "Este campo é necessário",
          number: "Deve ser número"
        },
        raio: {
          required: "Este campo é necessário",
          number: "Deve ser número"
        },
        nome: {
          required: "Este campo é necessário"
        },
    }
  });
})
</script>