<!DOCTYPE html>
<html>
<head>
	<title>Vigilancia</title>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="shortcut icon" type="image/x-icon" href="docs/images/favicon.ico" />


	<link rel="stylesheet" href="leaflet/leaflet.css" />
	<script src="leaflet/leaflet.js"></script>


</head>
<body>


<div id='map' style="width: 1200px; height: 800px;"></div>

<script>

	const vLatitude = 39.73;
	const vLongitude = -104.99;
	const vZoom = 10;


	let circulos = [
		[
			39.61,
			-105.02,
			'X', 
			23423, 
			'img/casa1.png',
			'green',
			'#58D68D',
			0.5,
			7000,
			'<b>  Soares</b><br>Rua Vale do Selke Pequeno, 830'
		],
		[
			39.72,
			-105.07,
			'Y', 
			7899, 
			'img/casa2.png',
			'red',
			'#f03',
			0.5,
			5000,
			'<b>Gabriela Vieira Soares</b><br>Rua Vale do Selke Grande, 1578 - Apto 123 Bloco B'
		]
	];


	let areas = [
		[
			'A', 
			23423, 
			'img/casa1.png',
			'blue',
			'#5DADE2',
			0.5,
			'<b>texto1</b><br>maior',
			[
				[39.61, -105.02, '<b>  Soares</b><br>Rua Vale do Selke Pequeno, 830'],
				[39.74, -104.99, '<b>Gabriela Vieira Soares</b><br>Rua Vale do Selke Grande, 1578 - Apto 123 Bloco B'],
				[39.73, -104.8,  '<b>Marina Vieira Soares</b><br>Avenida 21 de Janeiro, 3213 - fundos'],
				[39.77, -105.23, '<b>Arthur Carvalho Soares Neto</b><br>Rua dos Atiradores, 321']
			]
		],
		[
			'B', 
			7899, 
			'img/casa2.png',
			'yellow',
			'#F9E79F',
			0.5,
			'<b>texto2</b><br>maior',
			[
				[39.611, -105.024, '<b>12/12/2002</b><br>Realizada'],
				[39.742, -104.993, '<b>11/11/2022</b><br>Ausente'],
				[39.733, -104.82,  '<b>10/10/2019</b><br>Realizada'],
				[39.774, -105.231, '<b>12/04/2021</b><br>Realizada']
			]
		]
	];


	let camadas = [
		[
			'Microárea', 
			23423, 
			'img/casa1.png',
			'green',
			'#58D68D',
			0.5,
			[
				[39.61, -105.02, '<b>  Soares</b><br>Rua Vale do Selke Pequeno, 830'],
				[39.74, -104.99, '<b>Gabriela Vieira Soares</b><br>Rua Vale do Selke Grande, 1578 - Apto 123 Bloco B'],
				[39.73, -104.8,  '<b>Marina Vieira Soares</b><br>Avenida 21 de Janeiro, 3213 - fundos'],
				[39.77, -105.23, '<b>Arthur Carvalho Soares Neto</b><br>Rua dos Atiradores, 321']
			]
		],
		[
			'Visitas', 
			7899, 
			'img/casa2.png',
			'red',
			'#f03',
			0.5,
			[
				[39.611, -105.024, '<b>12/12/2002</b><br>Realizada'],
				[39.742, -104.993, '<b>11/11/2022</b><br>Ausente'],
				[39.733, -104.82,  '<b>10/10/2019</b><br>Realizada'],
				[39.774, -105.231, '<b>12/04/2021</b><br>Realizada']
			]
		]
	];

	const mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>';
	const mbUrl = 'https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
	const mbAttrOsm = '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>';
	const mbUrlOsm = 'https://tile.openstreetmap.org/{z}/{x}/{y}.png';

	const streets = L.tileLayer(mbUrl, {id: 'mapbox/streets-v11', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const satellite = L.tileLayer(mbUrl, {id: 'mapbox/satellite-v9', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const osm = L.tileLayer(mbUrlOsm, {maxZoom: 19, attribution: mbAttrOsm});

	const LeafIcon = L.Icon.extend({
		options: {
			iconSize:     [24, 24],
			iconAnchor:   [22, 94],
			popupAnchor:  [-3, -76]
		}
	});
	const overlays = {};
	let lays = [];
	lays[0] = streets;

	let grupo = [];
	let icone = [];
	let itmap = [];
	let polygon = [];
	var ct_itmap = 0;
	let pontos_polig = [];
    for(var i = 0; i < camadas.length; i++) {
		grupo[i] = L.layerGroup();
		icone[i] = new LeafIcon({iconUrl: camadas[i][2]});
		overlays[camadas[i][0]] = grupo[i];
		lays[i+1] = grupo[i];
		pontos_polig = [];
        for(var f = 0; f < camadas[i][6].length; f++) {
			itmap[ct_itmap] = L.marker([camadas[i][6][f][0], camadas[i][6][f][1]], {icon: icone[i]}).bindPopup(camadas[i][6][f][2]).addTo(grupo[i]);
			ct_itmap++;
			pontos_polig[f] = [camadas[i][6][f][0], camadas[i][6][f][1]];
        }
		polygon[i] = L.polygon([pontos_polig],{color: camadas[i][3], fillColor: camadas[i][4], fillOpacity: camadas[i][5]}).bindPopup(camadas[i][0]);
		overlays['Área: ' + camadas[i][0]] = polygon[i];
    }

	if (typeof circulos !== 'undefined') {
		let circle = [];
		var index_layc = lays.length - 1;
		for(var c = 0; c < circulos.length; c++) {
			circle[c] = L.circle([circulos[c][0], circulos[c][1]], {
				color: circulos[c][5],
				fillColor: circulos[c][6],
				fillOpacity: circulos[c][7],
				radius: circulos[c][8]
			}).bindPopup(circulos[c][9]);
			overlays['Foco: ' + circulos[c][2]] = circle[c];
			index_layc = index_layc + 1;
			lays[index_layc] = circle[c];
		}
	}

	if (typeof areas !== 'undefined') {
		let ipolygon = [];
		var index_layp = lays.length - 1;
		let pontos_polig_areai = [];
		for(var c = 0; c < areas.length; c++) {
			pontos_polig_areai = [];
			for(var f = 0; f < areas[c][7].length; f++) {
				pontos_polig_areai[f] = [areas[c][7][f][0], areas[c][7][f][1]];
			}
			ipolygon[c] = L.polygon([pontos_polig_areai],{color: areas[c][3], fillColor: areas[c][4], fillOpacity: areas[c][5]}).bindPopup(areas[c][0]);
			overlays['Área: ' + areas[c][0]] = ipolygon[c];
			index_layp = index_layp + 1;
			lays[index_layp] = ipolygon[c];
		}
	}


	const baseLayers = {
		'OpenStreetMap': osm,
		'Ruas': streets,
		'Satelite': satellite
	};
	const map = L.map('map', {
		center: [vLatitude, vLongitude],
		zoom: vZoom,
		layers: lays
	});
	const layerControl = L.control.layers(baseLayers, overlays).addTo(map);

	const popup = L.popup();
	function onMapClick(e) {
		popup
			.setLatLng(e.latlng)
			.setContent(`As coordenadas aqui são: ${e.latlng.toString()}`)
			.openOn(map);
	}
	map.on('click', onMapClick);












</script>



</body>
</html>