<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');
include('parametros.php');

$cfg_largura = $cfgeral_largura;
$cfg_altura = $cfgeral_altura;
$cfg_latitude = $cfgeral_latitude;
$cfg_longitude = $cfgeral_longitude;
$cfg_zoom = $cfgeral_zoom;
$masc = '';

$rs = $con->prepare("SELECT * FROM maps_tb_cf_geral WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$cfg_largura = $row->largura;
			$cfg_altura = $row->altura;
			$cfg_latitude = $row->latitude;
			$cfg_longitude = $row->longitude;
			$cfg_zoom = $row->zoom;
			$masc = $row->masc;
		}
	}
}

$invertido = false;
$mascat = array();
if (strlen($masc) > 0){
    if (strlen($masc) == 1 && $masc == '0'){
        $mascat[] = "todos";
    } else {
        if (strlen($masc) >= 2){
            if (substr($masc,0,1) == '-'){
                $invertido = true;
                $masc = substr($masc,1);
            }
            $pos = strpos($masc,';');
            if ($pos === false) {
                if (strlen($masc) == 2){
                    $mascat[] = $masc;
                }
            } else {
                $mascat = explode(';',$masc);
            }
        }
    }
} else {
	$mascat[] = "todos";
}

?>
<link rel="stylesheet" type="text/css" href="mod/maps/leaflet/leaflet.css">

<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Microáreas</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Parâmetros globais</p>
                  <form class="dt_adv_search" name="frm" id="frm" enctype="multipart/form-data" method="POST">
                	<input type="hidden" id="sb" name="sb" value="1">
                    <div class="row g-1 mb-md-1">
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <input type="file" class="custom-file-input" id="arquivo">
                                <label class="custom-file-label" for="arquivo">Selecione o arquivo KML ou CSV</label>
                            </div>
                        </div>
                        <button type="button" class="btn btn-primary" id="but_upload">Enviar</button>
                    </div>
                  </form>
                </div>
            </div>
        </div>
    </div>
</section>


<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Mapa</h4>
                </div>
                <div class="card-body mt-2">

                  <div id='mapm' style="width: <?php echo $cfg_largura;?>; height: <?php echo $cfg_altura;?>;"></div>

                </div>
            </div>
        </div>
    </div>
</section>
<!-- Bordered table start -->
<div class="row" id="table-bordered">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Polígonos (áreas)</h4>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>MA</th>
                            <th>Nome</th>
                            <th>Cor Borda</th>
                            <th>Cor Fundo</th>
							<th>Opacidade</th>
							<th>Ativo</th>
							<th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
<?php
	$primeira_coord = true;
	$primeira_lat = $cfg_latitude;
	$primeira_lon = $cfg_longitude;
	$matriz = "";
	$rs = $con->prepare("SELECT * FROM maps_tb_areas WHERE id = ? AND ibge = ?");
	$rs->bindParam(1,$_SESSION['login']);
	$rs->bindParam(2,$_SESSION['ibge']);
	if($rs->execute()){
		if($rs->rowCount() > 0){
			while($row = $rs->fetch(PDO::FETCH_OBJ)){
				$bt_ac = "Ativar";
				$status = "<span class=\"badge rounded-pill badge-light-danger me-1\">inativo</span>";
				$status_ac = 'a';
				if ($row->ativo == 1){
					$status = "<span class=\"badge rounded-pill badge-light-success me-1\">ativo</span>";
					$bt_ac = "Inativar";
					$status_ac = 'i';
				}
				$btacao0 = "
					<div class=\"dropdown\">
						<button type=\"button\" class=\"btn btn-sm dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
							<i data-feather=\"more-vertical\"></i>
						</button>
						<div class=\"dropdown-menu\">
							<a class=\"dropdown-item\" href=\"#\" onclick=\"opModal('#myModal','mod/maps/frm_ed_area.php?klink=".$row->klink."');\">
								<i data-feather=\"edit-2\" class=\"me-50\"></i>
								<span>Editar</span>
							</a>
							<a class=\"dropdown-item\" href=\"#\" onclick=\"SlickLoader.enable();$('.content-body').load('mod/maps/frm_ac_area.php?ac=e&klink=".$row->klink."');\">
								<i data-feather=\"trash\" class=\"me-50\"></i>
								<span>Excluir</span>
							</a>
							<a class=\"dropdown-item\" href=\"#\" onclick=\"SlickLoader.enable();$('.content-body').load('mod/maps/frm_ac_area.php?ac=".$status_ac."&klink=".$row->klink."');\">
								<i data-feather=\"x-circle\" class=\"me-50\"></i>
								<span>".$bt_ac."</span>
							</a>
						</div>
					</div>
				";
				$show_ma = "";
				if (strlen($row->ma) > 0){
					$show_ma = "<span class=\"badge rounded-pill badge-light-primary me-1\">".$row->ma."</span>";
				}
				echo "
					<tr>
						<td>".$row->idg."</td>
						<td>".$show_ma."</td>
						<td>".$row->nome."</td>
						<td><b style=\"color:".$row->cor_borda."\">".$row->cor_borda."</b></td>
						<td><b style=\"color:".$row->cor_fundo."\">".$row->cor_fundo."</b></td>
						<td>".$row->opacidade."</td>
						<td>".$status."</td>
						<td>".$btacao0."</td>
					</tr>
				";
				echo "
					<tr>
						<td colspan=\"8\">
							<a data-bs-toggle=\"collapse\" href=\"#tbp".$row->idg."\" aria-expanded=\"false\" aria-controls=\"tbp".$row->idg."\">>></a>
							<div class=\"collapse\" id=\"tbp".$row->idg."\">
							<table class=\"table table-bordered\">
								<thead>
									<tr>
										<th></th>
										<th>ID</th>
										<th>Latitude</th>
										<th>Longitude</th>
										<th>Ação</th>
									</tr>
								</thead>
								<tbody>
				";
				if ($row->ativo == 1){
					$matriz .= "['".$row->nome."',".$row->idg.",'".$row->icone."','".$row->cor_borda."','".$row->cor_fundo."',".$row->opacidade.",'".$row->descricao."',[";
				}
				$rsp = $con->prepare("SELECT * FROM maps_tb_areas_pontos WHERE id = ? AND ibge = ? AND klink = ?");
				$rsp->bindParam(1,$_SESSION['login']);
				$rsp->bindParam(2,$_SESSION['ibge']);
				$rsp->bindParam(3,$row->klink);
				if($rsp->execute()){
					$total_encontrado_pontos = $rsp->rowCount();
					if($total_encontrado_pontos > 0){
						while($rowp = $rsp->fetch(PDO::FETCH_OBJ)){
							$btacao = "";
							if ($total_encontrado_pontos > 3){
								$btacao = "
									<div class=\"dropdown\">
										<button type=\"button\" class=\"btn btn-sm dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
											<i data-feather=\"more-vertical\"></i>
										</button>
										<div class=\"dropdown-menu\">
											<a class=\"dropdown-item\" href=\"#\" onclick=\"opModal('#myModal','mod/maps/frm_ed_area_ponto.php?idg=".$rowp->idg."&klink=".$row->klink."');\">
												<i data-feather=\"edit-2\" class=\"me-50\"></i>
												<span>Editar</span>
											</a>
											<a class=\"dropdown-item\" href=\"#\" onclick=\"SlickLoader.enable();$('.content-body').load('mod/maps/frm_ac_area_ponto.php?ac=e&idg=".$rowp->idg."&klink=".$row->klink."');\">
												<i data-feather=\"trash\" class=\"me-50\"></i>
												<span>Excluir</span>
											</a>
										</div>
									</div>
								";
							}
							echo "
							<tr>
								<td></td>
								<td>".$rowp->idg."</td>
								<td>".$rowp->latitude."</td>
								<td>".$rowp->longitude."</td>
								<td>".$btacao."</td>
							</tr>
						";
							if ($row->ativo == 1){
								$matriz .= "[".$rowp->latitude.",".$rowp->longitude.",'".$rowp->descricao."'],";
							}
							if ($primeira_coord){
								$primeira_coord = false;
								$primeira_lat = $rowp->latitude;
								$primeira_lon = $rowp->longitude;
							}
						}
					}
				}
				if ($row->ativo == 1){
					$matriz .= "]],";
				}
				echo "
								</tbody>
							</table>
							</div>
						</td>
					</tr>
				";
			}
		}
	}
?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Bordered table end -->


<!-- Modal -->
<div class="modal fade text-start" id="myModal" data-bs-backdrop="static" data-bs-keyboard="false" role="dialog" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">Detalhes</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" onclick="SlickLoader.enable();$('.content-body').load('mod/maps/mas.php');">Fechar</button>
      </div>
    </div>
  </div>
</div>


<script src="mod/maps/leaflet/leaflet.js"></script>
<script>

SlickLoader.disable();

function opModal(idModal, url){
    $(idModal + ' .modal-body').load(url,function(e){
    	$(idModal).modal('show');
    });
}

$(function () {
	const vLatitude = <?php echo $primeira_lat;?>;
	const vLongitude = <?php echo $primeira_lon;?>;
	const vZoom = <?php echo $cfg_zoom;?>;


	
	let areas = [
		<?php echo $matriz;?>
	];
	

	/*
	let areas = [
		[
			'A', 
			23423, 
			'casa1.png',
			'blue',
			'#5DADE2',
			0.5,
			'<b>texto1</b><br>maior',
			[
				[-26.699568, -49.175133, '<b>  Soares</b><br>Rua Vale do Selke Pequeno, 830'],
				[-26.708565, -49.158171, '<b>Gabriela Vieira Soares</b><br>Rua Vale do Selke Grande, 1578 - Apto 123 Bloco B'],
				[-26.720402, -49.178667,  '<b>Marina Vieira Soares</b><br>Avenida 21 de Janeiro, 3213 - fundos'],
				[-26.716930, -49.183261, '<b>Arthur Carvalho Soares Neto</b><br>Rua dos Atiradores, 321'],
			],
		],
		[
			'B', 
			7899, 
			'casa2.png',
			'yellow',
			'#F9E79F',
			0.5,
			'<b>texto2</b><br>maior',
			[
				[-26.771001, -49.180167, '<b>12/12/2002</b><br>Realizada'],
				[-26.760683, -49.160625, '<b>11/11/2022</b><br>Ausente'],
				[-26.802514, -49.158524,  '<b>10/10/2019</b><br>Realizada'],
				[-26.794074, -49.184579, '<b>12/04/2021</b><br>Realizada'],
			],
		],


		[
			'estrada 2',
			1,
			'casa1.png',
			'red',
			'#f03',
			0.5,
			'teste 2',
			[
				[-26.6708054,-49.1908305,'teste'],
				[-26.6708054,-49.1909431,'teste'],
				[-26.6708461,-49.1909431,'teste'],
				[-26.670839 ,-49.1908224,'teste'],
				[-26.6708965,-49.1908197,'teste'],
				[-26.6708941,-49.1907715,'teste'],
				[-26.6708342,-49.1907715,'teste'],
				[-26.6708126,-49.1903423,'teste'],
				[-26.6707718,-49.1902779,'teste'],
				[-26.6708054,-49.1908305,'teste'],
			]
		],
		[
			'plano2',
			2,
			'casa1.png',
			'red',
			'#f03',
			0.5,
			'teste 2',
			[
				[-26.6711886,-49.1917156,'teste'],
				[-26.6711647,-49.1911684,'teste'],
				[-26.6709322,-49.1911792,'teste'],
				[-26.6709513,-49.1917236,'teste'],
				[-26.6711886,-49.1917156,'teste'],
			]
		],
		[
			'olanbo1',
			3,
			'casa1.png',
			'red',
			'#f03',
			0.5,
			'teste 2',
			[
				[-26.670928,-49.1908644,'teste'],
				[-26.6709376,-49.1911568,'teste'],
				[-26.6711677,-49.191146,'teste'],
				[-26.6711629,-49.1910253,'teste'],
				[-26.6711246,-49.1909985,'teste'],
				[-26.6710958,-49.1909181,'teste'],
				[-26.6710718,-49.1908564,'teste'],
				[-26.670928,-49.1908644,'teste'],
			]
		],
	];
	*/

	const mbAttr = 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>';
	const mbUrl = 'https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoibWFwYm94IiwiYSI6ImNpejY4NXVycTA2emYycXBndHRqcmZ3N3gifQ.rJcFIG214AriISLbB6B5aw';
	const mbAttrOsm = '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>';
	const mbUrlOsm = 'https://tile.openstreetmap.org/{z}/{x}/{y}.png';
	const mbUrlCarto = 'https://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png';
	const mbCarto = '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="https://carto.com/attribution">CARTO</a>';

	const positron = L.tileLayer(mbUrlCarto, {attribution: mbCarto});
	const streets = L.tileLayer(mbUrl, {id: 'mapbox/streets-v11', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const satellite = L.tileLayer(mbUrl, {id: 'mapbox/satellite-v9', tileSize: 512, zoomOffset: -1, attribution: mbAttr});
	const osm = L.tileLayer(mbUrlOsm, {maxZoom: 19, attribution: mbAttrOsm});

	const LeafIcon = L.Icon.extend({
		options: {
			iconSize:     [24, 24],
			iconAnchor:   [22, 94],
			popupAnchor:  [-3, -76]
		}
	});
	const overlays = {};
	let lays = [];
	lays[0] = <?php echo $mapa_abertura;?>;

	if (typeof areas !== 'undefined') {
		let ipolygon = [];
		var index_layp = lays.length - 1;
		let pontos_polig_areai = [];
		for(var c = 0; c < areas.length; c++) {
			pontos_polig_areai = [];
			for(var f = 0; f < areas[c][7].length; f++) {
				pontos_polig_areai[f] = [areas[c][7][f][0], areas[c][7][f][1]];
			}
			ipolygon[c] = L.polygon([pontos_polig_areai],{color: areas[c][3], fillColor: areas[c][4], fillOpacity: areas[c][5]}).bindPopup(areas[c][0]);
			overlays['Área: ' + areas[c][0]] = ipolygon[c];
			index_layp = index_layp + 1;
			lays[index_layp] = ipolygon[c];
		}
	}

	const baseLayers = {
		'OpenStreetMap': osm,
		'Ruas': streets,
		'Satelite': satellite,
		'Mapa': positron
	};
	const map = L.map('mapm', {
		center: [vLatitude, vLongitude],
		zoom: vZoom,
		layers: lays
	});
	const layerControl = L.control.layers(baseLayers, overlays).addTo(map);

	const popup = L.popup();
	function onMapClick(e) {
    const ta1 = e.latlng.toString().split("(");
    const ta2 = ta1[1].split(",");
    const tLatitude = ta2[0].trim();
    const tLongitude = ta2[1].substring(0,ta2[1].length-1).trim();
		popup
			.setLatLng(e.latlng)
			.setContent('As coordenadas aqui são: ' + tLatitude + ', ' + tLongitude + '<br><a href="https://maps.google.com/?q=' + tLatitude + ',' + tLongitude + '" target="_blank">Mapa</a>')
			.openOn(map);
	}
	map.on('click', onMapClick);


	$("#but_upload").click(function() {
		var fd = new FormData(frm);
		var files = $('#arquivo')[0].files[0];
		fd.append('arquivo', files);
	
		$.ajax({
			url: 'mod/maps/gv_kml.php',
			type: 'post',
			data: fd,
			contentType: false,
			processData: false,
			success: function(response){
				if(response.substring(0,2) == 'Ok'){
					swal.fire('Ok!',response,'success');
					$('.content-body').load('proc.php?ap=mod/maps/proc_kml');
				} else{
					swal.fire('erro!',response,'error');
				}
			},
		});
    });

	if (feather) {
        feather.replace({
            width: 14,
            height: 14
        });
    }

});
</script>