<?php
$sql_pg_painel = "
    SELECT
        t1.co_seq_atend AS senha,
        t2.no_status_atend AS status,
        t2.co_status_atend AS estagio,
        upper(t4.no_cidadao) AS cidadao,
        t4.dt_nascimento,
        t4.nu_cpf AS cpf,
        t4.nu_cns AS cns,
        CASE WHEN t4.no_sexo = 'FEMININO' THEN 'F' WHEN t4.no_sexo = 'MASCULINO' THEN 'M' END AS sexo,
        t1.dt_criacao_registro AS tempo,
        upper(t6.no_profissional) AS profissional,
        t6.nu_cns AS prof_cns,
        t6.nu_cpf AS prof_cpf,
        t8.co_cbo_2002 AS prof_cbo_nu,
        t8.no_cbo AS prof_cbo,
        t10.nu_ine AS prof_ine,
        t10.no_equipe AS prof_equipe,
        t9.nu_cnes AS cnes,
        t9.no_unidade_saude AS unidade,
        t1.dt_ultima_alteracao_status AS tempo_atendido,
        t1.dt_ultima_alteracao_status AS tempo_cancelado,
        t11.no_classificacao_risco,
        t11.co_classificacao_risco
    FROM 
        tb_atend t1
        LEFT JOIN tb_status_atend t2 ON t2.co_status_atend = t1.st_atend
        LEFT JOIN tb_prontuario t3 On t3.co_seq_prontuario = t1.co_prontuario
        LEFT JOIN tb_cidadao t4 On t4.co_seq_cidadao = t3.co_cidadao
        LEFT JOIN tb_ator_papel t5 On t1.co_responsavel = t5.co_seq_ator_papel
        LEFT JOIN tb_prof t6 On t6.co_seq_prof = t5.co_prof
        LEFT JOIN tb_lotacao t7 On t7.co_prof = t6.co_seq_prof
        LEFT JOIN tb_cbo t8 On t8.co_cbo = t7.co_cbo
        LEFT JOIN tb_unidade_saude t9 On t1.co_unidade_saude = t9.co_seq_unidade_saude
        LEFT JOIN tb_equipe t10 On t1.co_equipe = t10.co_seq_equipe
        LEFT JOIN tb_classificacao_risco t11 On t1.co_classificacao_risco = t11.co_classificacao_risco
    WHERE 
        t7.dt_desativacao_lotacao IS NULL 
        AND DATE(t1.dt_criacao_registro) = ?
";


$sql_pg_servicos = "
    SELECT
        t3.no_tipo_servico
    FROM 
        tb_atend t1
        LEFT JOIN rl_atend_tipo_servico t2 On t1.co_seq_atend = t2.co_atend
        LEFT JOIN tb_tipo_servico t3 On t3.co_seq_tipo_servico = t2.tp_servico
    WHERE
        --t3.no_tipo_servico notnull AND
        t3.no_tipo_servico = 'VACINA' AND
        t1.co_seq_atend = ?
";

?>