<?php

session_start();

require_once('../../cfg/mydb.php');
$sec_login = $_SESSION['login'];

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$quadrimestre_selecionado = isset($_GET["qg"]) ? $_GET["qg"] : 0;

// https://datatables.net/forums/discussion/49799/datatable-ssp-class-php
// https://datatables.net/examples/data_sources/server_side.html

// Database connection info 
$dbDetails = array( 
    'host' => MYSQL_HOST, 
    'user' => MYSQL_USER, 
    'pass' => MYSQL_PASSWORD, 
    'db'   => MYSQL_DB_NAME,
    'port' => MYSQL_PORT
); 
 
// DB table to use 
$table = 'prevbra_tb_ind_gerado'; 
 
// Table's primary key 
$primaryKey = 'idkey'; 
 
// Array of database columns which should be read and sent back to DataTables. 
// The `db` parameter represents the column name in the database.  
// The `dt` parameter represents the DataTables column identifier. 
$columns = array( 
    array(
        'db'        => 'indicador1', 
        'dt'        => 0
    ),
    array(
        'db'        => 'indicador2', 
        'dt'        => 1
    ),
    array(
        'db'        => 'indicador3', 
        'dt'        => 2
    ),
    array( 
        'db'        => 'nome',      
        'dt'        => 3, 
        'formatter' => function($d, $row) { 
            $fdata = $d;
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "********** *************** ***********";
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        } 
    ), 
    array( 
        'db'        => 'cpf', 
        'dt'        => 4, 
        'formatter' => function( $d, $row ) { 
            $fdata = $d;
            if (strlen($d) <= 0 || $d == '0'){
                $fdata = 'CPF';
            }
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                if (strlen($fdata) == 11){
                    $fdata = "***".substr($fdata,3,3)."***".substr($fdata,9,2);
                }
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cnes', 
        'dt'        => 5, 
        'formatter' => function($d, $row) { 
            $fdata = $d;

            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "*******";
            }
            // ----------------------------------------------------------------------------------

            if (strlen(trim($d)) < 5){
                $fdata = "SU";
            }
            return $fdata; 
        } 
    ), 
    array(
        'db'        => 'unidade', 
        'dt'        => 6, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-clinic-medical\" title=\"".$d."\"></i>";
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'ine', 
        'dt'        => 7, 
        'formatter' => function($d, $row) { 
            $fdata = $d;


            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "0000******";
            }
            // ----------------------------------------------------------------------------------


            if (strlen(trim($d)) < 5){
                $fdata = "SE";
            }
            return $fdata; 
        } 
    ), 
    array(
        'db'        => 'equipe', 
        'dt'        => 8, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-layer-group\" title=\"".$d."\"></i>";
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dpp', 
        'dt'        => 9, 
        'formatter' => function( $d, $row ) { 
            $fdata = date('d/m/Y', strtotime($d));
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'numConsultas', 
        'dt'        => 10, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-briefcase-medical text-danger\" title=\"".$d."\"></i> ".$d;
            if ($d >= 6){
                $fdata = "<i class=\"fas fa-briefcase-medical text-success\" title=\"".$d."\"></i> ".$d;
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador12d', 
        'dt'        => 11, 
        'formatter' => function( $d, $row ) { 
            $ar_d = explode(":",$d);
            $dt1con = '';
            $dtdum = '';
            $dtSemC = '';
            if (strlen($ar_d[1]) == 8 && strlen($ar_d[2]) == 8 && strlen($ar_d[3]) == 8){
                $dt1con = date('d/m/Y', strtotime($ar_d[1]));
                $dtdum = date('d/m/Y', strtotime($ar_d[2]));
                $dtSemC = date('d/m/Y', strtotime($ar_d[3]));
            }
            $fdata = "<i class=\"fas fa-hand-holding-heart text-danger\" title=\"1ª cons.: ".$dt1con." | DUM: ".$dtdum." | 12ª Sem.: ".$dtSemC."\"></i>";
            if ($ar_d[0] == 1){
                $fdata = "<i class=\"fas fa-hand-holding-heart text-success\" title=\"1ª cons.: ".$dt1con." | DUM: ".$dtdum." | 12ª Sem.: ".$dtSemC."\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador21', 
        'dt'        => 12, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-microscope text-danger\" title=\"Não\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-microscope text-success\" title=\"Sim\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador22', 
        'dt'        => 13, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-microscope text-danger\" title=\"Não\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-microscope text-success\" title=\"Sim\"></i>";
            }
            return $fdata; 
        } 
    ),
    array(
        'db'        => 'mae', 
        'dt'        => 14, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fa fa-info\" title=\"Mãe: ".$d."\"></i>"; // text-danger
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'ma',        
        'dt'        => 15, 
        'formatter' => function($d, $row) { 
            $fdata = "MA_x";
            if (strlen(trim($d)) > 0){
                $fdata = "MA_".trim($d); 
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cns', 
        'dt'        => 16, 
        'formatter' => function( $d, $row ) { 
            $fdata = $d;
            if (strlen($d) <= 0 || $d == '0'){
                $fdata = 'CNS';
            }
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                if (strlen($fdata) == 15){
                    $fdata = substr($fdata,0,3)."****".substr($fdata,7,4)."****";
                }
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dtNascimento', 
        'dt'        => 17, 
        'formatter' => function( $d, $row ) { 
            return date('d/m/Y', strtotime($d)); 
        } 
    ),
    array( 
        'db'        => 'idade', 
        'dt'        => 18
    ),
    array( 
        'db'        => 'excluir', 
        'dt'        => 19
    ),
    array( 
        'db'        => 'baixa', 
        'dt'        => 20, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-circle text-success\" title=\"Ativo\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-plane-departure text-danger\" title=\"Baixado por mudança de território\"></i>";
            }
            if ($d == 2){
                $fdata = "<i class=\"fas fa-skull-crossbones text-danger\" title=\"Baixado por óbito\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'interrupcao', 
        'dt'        => 21,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-circle text-success\" title=\"Gestação em curso, sem interrupção\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-baby text-warning\" title=\"Interrupção, nascido vivo\"></i>";
            }
            if ($d == 2){
                $fdata = "<i class=\"fas fa-circle text-warning\" title=\"Interrupção, natimorto\"></i>";
            }
            if ($d == 3){
                $fdata = "<i class=\"fas fa-times-circle text-danger\" title=\"Aborto\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'ine', 
        'dt'        => 22, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-circle text-success\" title=\"Com equipe\"></i>";
            if (strlen(trim($d)) < 5){
                $fdata = "<i class=\"fas fa-exclamation-triangle text-danger\" title=\"Sem equipe\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dt_inter', 
        'dt'        => 23, 
        'formatter' => function($d, $row) {
            $fdata = '';
            if ($d > 0){
                $fdata = "<i class=\"fas fa-exclamation-triangle text-warning\" title=\"Interrupção em: ".date('d/m/Y', strtotime($d))."\"></i>";
            } 
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cpf', 
        'dt'        => 24, 
        'formatter' => function( $d, $row ) { 
            $fdata = trim($d);
            if (strlen($d) <= 0){
                $fdata = '0';
            }
            return $fdata; 
        } 
    ),
    array(
        'db'        => 'cns', 
        'dt'        => 25, 
        'formatter' => function( $d, $row ) { 
            $fdata = trim($d);
            if (strlen($d) <= 0){
                $fdata = '0';
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dtf',        
        'dt'        => 26 
    ),
    array( 
        'db'        => 'dpp',        
        'dt'        => 27 
    ),
    array( 
        'db'        => 'sexo',        
        'dt'        => 28,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fa fa-venus  text-success\"></i>";
            if ($d == 'MASCULINO'){
                $fdata = "<i class=\"fa fa-mars  text-danger\" title=\"Está como masculino\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'marc_gest',        
        'dt'        => 29,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-circle\" title=\"Não está marcada como gestante\"></i>";
            if ($d > 0){
                $fdata = "<i class=\"fas fa-circle text-success\" title=\"Marcado como gestante\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'sexo',        
        'dt'        => 30
    ),
    array( 
        'db'        => 'ligacao',        
        'dt'        => 31
    ),
    array( 
        'db'        => 'cidadao',        
        'dt'        => 32
    ),
    array( 
        'db'        => 'obs',
        'dt'        => 33,
        'formatter' => function($d, $row) { 
            $fdata = "";
            if (strlen(trim($d)) > 0){
                $fdata = "1";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'marc_gest',        
        'dt'        => 34,
        'formatter' => function( $d, $row ) { 
            $fdata = "NM";
            if ($d > 0){
                $fdata = "SM";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador1',        
        'dt'        => 35,
        'formatter' => function( $d, $row ) { 
            $fdata = "NNU1";
            if ($d > 0){
                $fdata = "SNU1";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador2',        
        'dt'        => 36,
        'formatter' => function( $d, $row ) { 
            $fdata = "NNU2";
            if ($d > 0){
                $fdata = "SNU2";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador3',        
        'dt'        => 37,
        'formatter' => function( $d, $row ) { 
            $fdata = "NNU3";
            if ($d > 0){
                $fdata = "SNU3";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'consulta1', 
        'dt'        => 38, 
        'formatter' => function( $d, $row ) { 
            return date('d/m/Y', strtotime($d)); 
        } 
    ),
    array( 
        'db'        => 'marc_ac',        
        'dt'        => 39,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-medkit\" title=\"Não está em Apoio ao Cuidado\"></i>";
            if ($d > 0){
                $fdata = "<i class=\"fas fa-medkit text-success\" title=\"Apoio ao Cuidado\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'telefone',        
        'dt'        => 40,
        'formatter' => function( $d, $row ) { 
            if (strlen($d) < 7){
                $fdata = "";
            } else {
                $fdata = "<a href=\"https://wa.me/+55".$d."?text=Oi!\" target=\"_blank\"><i class=\"fab fa-whatsapp\"></i></a>&nbsp;<a href=\"https://t.me/+55".$d."\" target=\"_blank\"><i class=\"fab fa-telegram\"></i></a>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cidadaoc',        
        'dt'        => 41
    ),
    array( 
        'db'        => 'cidadao2',        
        'dt'        => 42
    )
); 

$busca_indicador = 123;
if ($sec_login == 'admin'){
    $whereAll = "id = 'admin' AND quadrimestre = ".$quadrimestre_selecionado." AND indicador = ".$busca_indicador." AND ibge = '".$_SESSION['ibge']."'";
} else {
    $busca_ine = "ine = '".$_SESSION['ine']."' AND";
    if ($_SESSION['ine'] == '0000000000'){
        $busca_ine = "";
    } else {
        if (strlen($_SESSION['ine']) < 10){
            $busca_ine = "";
        } else {
            if (strlen($_SESSION['ine']) > 15){
                $ine_array = explode(",",$_SESSION['ine']);
                $wp_ine = "";
                if (count($ine_array) > 0){
                    $wp_ine = "ine IN (";
                    foreach ($ine_array as $v) {
                        $wp_ine .= "'".$v."',";
                    }
                    $wp_ine = substr($wp_ine,0,-1);
                    $wp_ine .= ")";
                    $busca_ine = $wp_ine." AND";
                }
            }
        }
    }
    $busca_cnes = "cnes = '".$_SESSION['cnes']."' AND";
    if ($_SESSION['cnes'] == '0000000' || strlen($_SESSION['cnes']) < 7){
        $busca_cnes = "";
    }
    $whereAll = "id = 'admin' AND quadrimestre = ".$quadrimestre_selecionado." AND ".$busca_ine." ".$busca_cnes." indicador = ".$busca_indicador." AND ibge = '".$_SESSION['ibge']."'";
}


// Include SQL query processing class 
require '../../class/_ssp.class.php'; 


$v = SSP::complex($_GET, $dbDetails, $table, $primaryKey, $columns, null, $whereAll);
echo json_encode($v);


/*
// Output data as json format 
echo json_encode( 
    //SSP::simple($_GET, $dbDetails, $table, $primaryKey, $columns) 
    SSP::complex ( $_GET, $dbDetails, $table, $primaryKey, $columns, null, $whereAll )
);
*/