<?php

session_start();

require_once('../../cfg/mydb.php');
$sec_login = $_SESSION['login'];

$scsus_demo = false;
if (isset($scsus_demonstracao)){
    if ($scsus_demonstracao){
        $scsus_demo = true;
    }
}

$quadrimestre_selecionado = isset($_GET["qg"]) ? $_GET["qg"] : 0;

// https://datatables.net/forums/discussion/49799/datatable-ssp-class-php
// https://datatables.net/examples/data_sources/server_side.html

// Database connection info 
$dbDetails = array( 
    'host' => MYSQL_HOST, 
    'user' => MYSQL_USER, 
    'pass' => MYSQL_PASSWORD, 
    'db'   => MYSQL_DB_NAME,
    'port' => MYSQL_PORT
); 
 
// DB table to use 
$table = 'prevbra_tb_ind_gerado'; 
 
// Table's primary key 
$primaryKey = 'idkey'; 
 
// Array of database columns which should be read and sent back to DataTables. 
// The `db` parameter represents the column name in the database.  
// The `dt` parameter represents the DataTables column identifier. 
$columns = array( 
    array(
        'db'        => 'indicador5', 
        'dt'        => 0
    ),
    array( 
        'db'        => 'nome',      
        'dt'        => 1, 
        'formatter' => function($d, $row) { 
            $fdata = $d;
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "********** *************** ***********";
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        }  
    ), 
    array( 
        'db'        => 'cpf', 
        'dt'        => 2, 
        'formatter' => function( $d, $row ) { 
            $fdata = $d;
            if (strlen($d) <= 0 || $d == '0'){
                $fdata = 'CPF';
            }
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                if (strlen($fdata) == 11){
                    $fdata = "***".substr($fdata,3,3)."***".substr($fdata,9,2);
                }
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cnes', 
        'dt'        => 3, 
        'formatter' => function($d, $row) { 
            $fdata = $d;

            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "*******";
            }
            // ----------------------------------------------------------------------------------

            if (strlen(trim($d)) < 5){
                $fdata = "SU";
            }
            return $fdata; 
        } 
    ), 
    array(
        'db'        => 'unidade', 
        'dt'        => 4, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-clinic-medical\" title=\"".$d."\"></i>";
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'ine', 
        'dt'        => 5, 
        'formatter' => function($d, $row) { 
            $fdata = $d;

            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "0000******";
            }
            // ----------------------------------------------------------------------------------

            if (strlen(trim($d)) < 5){
                $fdata = "SE";
            }
            return $fdata; 
        } 
    ), 
    array(
        'db'        => 'equipe', 
        'dt'        => 6, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-layer-group\" title=\"".$d."\"></i>";
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dtNascimento', 
        'dt'        => 7, 
        'formatter' => function( $d, $row ) { 
            $fdata = date('d/m/Y', strtotime($d));
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                $fdata = "**/**/".substr($fdata,6,4);
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        } 
    ),
    array(
        'db'        => 'mae', 
        'dt'        => 8, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fa fa-info\" title=\"Mãe: ".$d."\"></i>"; // text-danger
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'ma',        
        'dt'        => 9, 
        'formatter' => function($d, $row) { 
            $fdata = "MA_x";
            if (strlen(trim($d)) > 0){
                $fdata = "MA_".trim($d); 
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cns', 
        'dt'        => 10, 
        'formatter' => function( $d, $row ) { 
            $fdata = $d;
            if (strlen($d) <= 0 || $d == '0'){
                $fdata = 'CNS';
            }
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            $scsus_demo = $GLOBALS['scsus_demo'];
            // ----------------------------------------------------------------------------------
            // ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            // ----------------------------------------------------------------------------------
            if ($scsus_demo){
                if (strlen($fdata) == 15){
                    $fdata = substr($fdata,0,3)."****".substr($fdata,7,4)."****";
                }
            }
            // ----------------------------------------------------------------------------------
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'idade', 
        'dt'        => 11
    ),
    array( 
        'db'        => 'excluir', 
        'dt'        => 12
    ),
    array( 
        'db'        => 'baixa', 
        'dt'        => 13, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-circle text-success\" title=\"Ativo\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-plane-departure text-danger\" title=\"Baixado por mudança de território\"></i>";
            }
            if ($d == 2){
                $fdata = "<i class=\"fas fa-skull-crossbones text-danger\" title=\"Baixado por óbito\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'ine', 
        'dt'        => 14, 
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-circle text-success\" title=\"Com equipe\"></i>";
            if (strlen(trim($d)) < 5){
                $fdata = "<i class=\"fas fa-exclamation-triangle text-danger\" title=\"Sem equipe\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cpf', 
        'dt'        => 15, 
        'formatter' => function( $d, $row ) { 
            $fdata = trim($d);
            if (strlen($d) <= 0){
                $fdata = '0';
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cns', 
        'dt'        => 16, 
        'formatter' => function( $d, $row ) { 
            $fdata = trim($d);
            if (strlen($d) <= 0){
                $fdata = '0';
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dtf',        
        'dt'        => 17
    ),
    array( 
        'db'        => 'sexo',        
        'dt'        => 18,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fa fa-venus text-danger\"></i>";
            if ($d == 'MASCULINO'){
                $fdata = "<i class=\"fa fa-mars text-primary\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'sexo',        
        'dt'        => 19
    ),
    array( 
        'db'        => 'ligacao',        
        'dt'        => 20
    ),
    array( 
        'db'        => 'cidadao',        
        'dt'        => 21
    ),
    array( 
        'db'        => 'dtNascimento',        
        'dt'        => 22
    ),
    array( 
        'db'        => 'alerta_idade',
        'dt'        => 23,
        'formatter' => function($d, $row) { 
            $fdata = "";
            if (strlen($d) > 0){
                if (substr($d,1,1) == "l"){
                    $fdata = "<i class=\"fas fa-stopwatch-20 text-warning\" title=\"Último mês para procurar a criança\"></i>";
                } else {
                    $fdata = "<i class=\"fas fa-stopwatch-20 text-danger\" title=\"Passou o prazo para realizar a vacina\"></i>";
                }
                
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'po_comp',        
        'dt'        => 24,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-arrow-alt-circle-down text-danger\" title=\"Esquema POLIO incompleto\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-arrow-alt-circle-up text-success\" title=\"Esquema POLIO completo\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'pe_comp',        
        'dt'        => 25,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-caret-square-down text-danger\" title=\"Esquema PENTA incompleto\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-caret-square-up text-success\" title=\"Esquema PENTA completo\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'he_comp',        
        'dt'        => 26,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-arrow-circle-down text-danger\" title=\"Esquema HEXA incompleto\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-arrow-circle-up text-success\" title=\"Esquema HEXA completo\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'dose_d3',        
        'dt'        => 27,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-layer-group text-danger\" title=\"Não tem a terceira dose de Penta e Polio ou Hexa\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-layer-group text-success\" title=\"Tem a terceira dose de Penta e Polio ou Hexa\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'obs',
        'dt'        => 28,
        'formatter' => function($d, $row) { 
            $fdata = "";
            if (strlen(trim($d)) > 0){
                $fdata = "1";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'obs_vacina',
        'dt'        => 29,
        'formatter' => function($d, $row) { 
            $fdata = "";
            if (strlen(trim($d)) > 0){
                $fdata = "1";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador5',        
        'dt'        => 30,
        'formatter' => function( $d, $row ) { 
            $fdata = "NNU";
            if ($d > 0){
                $fdata = "SNU";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'marc_ac',        
        'dt'        => 31,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-medkit\" title=\"Não está em Apoio ao Cuidado\"></i>";
            if ($d > 0){
                $fdata = "<i class=\"fas fa-medkit text-success\" title=\"Apoio ao Cuidado\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'telefone',        
        'dt'        => 32,
        'formatter' => function( $d, $row ) { 
            if (strlen($d) < 7){
                $fdata = "";
            } else {
                $fdata = "<a href=\"https://wa.me/+55".$d."?text=Oi!\" target=\"_blank\"><i class=\"fab fa-whatsapp\"></i></a>&nbsp;<a href=\"https://t.me/+55".$d."\" target=\"_blank\"><i class=\"fab fa-telegram\"></i></a>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador51',        
        'dt'        => 33,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-syringe text-danger\" title=\"Sem POLIO dose 3\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-syringe text-success\" title=\"POLIO dose 3\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador52',        
        'dt'        => 34,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-syringe text-danger\" title=\"Sem PENTA dose 3\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-syringe text-success\" title=\"PENTA dose 3\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'indicador53',        
        'dt'        => 35,
        'formatter' => function( $d, $row ) { 
            $fdata = "<i class=\"fas fa-syringe text-danger\" title=\"Sem HEXA dose 3\"></i>";
            if ($d == 1){
                $fdata = "<i class=\"fas fa-syringe text-success\" title=\"HEXA dose 3\"></i>";
            }
            return $fdata; 
        } 
    ),
    array( 
        'db'        => 'cidadaoc',        
        'dt'        => 36
    )
); 

$busca_indicador = 5;
if ($sec_login == 'admin'){
    $whereAll = "id = 'admin' AND quadrimestre = ".$quadrimestre_selecionado." AND indicador = ".$busca_indicador." AND ibge = '".$_SESSION['ibge']."'";
} else {
    $busca_ine = "ine = '".$_SESSION['ine']."' AND";
    if ($_SESSION['ine'] == '0000000000'){
        $busca_ine = "";
    } else {
        if (strlen($_SESSION['ine']) < 10){
            $busca_ine = "";
        } else {
            if (strlen($_SESSION['ine']) > 15){
                $ine_array = explode(",",$_SESSION['ine']);
                $wp_ine = "";
                if (count($ine_array) > 0){
                    $wp_ine = "ine IN (";
                    foreach ($ine_array as $v) {
                        $wp_ine .= "'".$v."',";
                    }
                    $wp_ine = substr($wp_ine,0,-1);
                    $wp_ine .= ")";
                    $busca_ine = $wp_ine." AND";
                }
            }
        }
    }
    $busca_cnes = "cnes = '".$_SESSION['cnes']."' AND";
    if ($_SESSION['cnes'] == '0000000' || strlen($_SESSION['cnes']) < 7){
        $busca_cnes = "";
    }
    $whereAll = "id = 'admin' AND quadrimestre = ".$quadrimestre_selecionado." AND ".$busca_ine." ".$busca_cnes." indicador = ".$busca_indicador." AND ibge = '".$_SESSION['ibge']."'";
}

// Include SQL query processing class 
require '../../class/_ssp.class.php'; 


$v = SSP::complex($_GET, $dbDetails, $table, $primaryKey, $columns, null, $whereAll);
echo json_encode($v);


/*
// Output data as json format 
echo json_encode( 
    //SSP::simple($_GET, $dbDetails, $table, $primaryKey, $columns) 
    SSP::complex ( $_GET, $dbDetails, $table, $primaryKey, $columns, null, $whereAll )
);
*/