<?php
date_default_timezone_set("America/Sao_Paulo");
require_once('../../cfg/mydb.php');
require_once('../../core/con_my.php');
require_once('../../core/functions.php');

$tem_bpa = false;
$tem_cnes = false;
$rs = $con->query("select modulo from sc_tb_modulos");
if($rs->rowCount() > 0){
    while($row = $rs->fetch(PDO::FETCH_OBJ)){
        if ($row->modulo == 'bpa'){
            $tem_bpa = true;
        }
        if ($row->modulo == 'cnes'){
            $tem_cnes = true;
        }
    }
}

if ($tem_bpa){
    $tem_bpa = false;
    $rs = $con->query("select * from bpa_tb_sig_cbos limit 100");
    if($rs->rowCount() > 0){
        $tem_bpa = true;
    }
}
if ($tem_cnes){
    $tem_cnes = false;
    $rs = $con->query("select * from cnes_tbatividadeprofissional limit 100");
    if($rs->rowCount() > 0){
        $tem_cnes = true;
    }
}

$cbos = array();
$cbos_conta = 0;
if ($tem_bpa || $tem_cnes){
    if ($tem_bpa){
        $rs = $con->query("select * from bpa_tb_sig_cbos");
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $cbos[$cbos_conta]['codigo'] = $row->cbo;
                $cbos[$cbos_conta]['nome'] = $row->nome;
                $cbos_conta++;
            }
        }
    } else {
        $rs = $con->query("select * from cnes_tbatividadeprofissional");
        if($rs->rowCount() > 0){
            while($row = $rs->fetch(PDO::FETCH_OBJ)){
                $cbos[$cbos_conta]['codigo'] = $row->CO_CBO;
                $cbos[$cbos_conta]['nome'] = $row->DS_ATIVIDADE_PROFISSIONAL;
                $cbos_conta++;
            }
        }
    }
}
?>

<!DOCTYPE html>
<html class="loading" lang="pt-br" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <title>Serviço CBO</title>
    <link rel="apple-touch-icon" href="../../app-assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="../../app-assets/images/ico/favicon.ico">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600" rel="stylesheet">


    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/vendors.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/charts/apexcharts.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/extensions/toastr.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/extensions/sweetalert2.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/pickers/pickadate/pickadate.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/pickers/flatpickr/flatpickr.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/forms/select/select2.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/forms/wizard/bs-stepper.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/spinner/slick-loader.min.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/vendors/css/daterangepicker/daterangepicker.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/colors.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/components.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/themes/dark-layout.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/themes/bordered-layout.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/themes/semi-dark-layout.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/core/menu/menu-types/horizontal-menu.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/pages/dashboard-ecommerce.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/charts/chart-apex.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/forms/pickers/form-flat-pickr.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/forms/pickers/form-pickadate.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/forms/form-validation.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/forms/form-wizard.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/extensions/progresscircle.css">
    <link rel="stylesheet" type="text/css" href="../../app-assets/css/plugins/extensions/ext-component-toastr.css">
    <!-- END: Page CSS-->

</head>
<!-- END: Head-->
<!-- BEGIN: Body-->
<body class="horizontal-layout horizontal-menu blank-page navbar-floating footer-static  " data-open="hover" data-menu="horizontal-menu" data-col="blank-page" data-framework="rss" data-asset-path="../../app-assets/">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper container-xxl p-0">
        <div class="content-body">
            <!-- Column Search -->
            <section id="column-search-datatable">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header border-bottom">
                                <h4 class="card-title">CBO - Classificação Brasileira de Ocupações</h4>
                            </div>
                            <div class="card-datatable">
                                <table class="dt-locolunas table">
                                    <thead>
                                        <th>Código</th>
                                        <th>Nome</th>
                                    </thead>
                                    <?php
                                    if (count($cbos) > 0){
                                        for ($i=0;$i<count($cbos);$i++){
                                            echo "<tr><td>".$cbos[$i]['codigo']."</td><td>".$cbos[$i]['nome']."</td></tr>";
                                        }
                                    }
                                    ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Column Search -->
        </div>
    </div>
</div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        <p class="clearfix mb-0"><span class="float-md-start d-block d-md-inline-block mt-25">COPYRIGHT &copy; 2021<a class="ms-25" href="https://gestor.mms.inf.br" target="_blank"> +Gestor Saúde</a><span class="d-none d-sm-inline-block">, All rights Reserved</span></span><span class="float-md-end d-none d-md-block">Central de serviços<i data-feather="heart"></i></span></p>
    </footer>
    <button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>
    <!-- END: Footer-->


    <!-- BEGIN: Vendor JS-->
    <script src="../../app-assets/vendors/js/vendors.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="../../app-assets/vendors/js/spinner/slick-loader.min.js"></script>
    <script src="../../app-assets/vendors/js/ui/jquery.sticky.js"></script>
    <script src="../../app-assets/vendors/js/extensions/toastr.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/select/select2.full.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/wizard/bs-stepper.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/validation/jquery.validate.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/validation/additional-methods.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/validation/jquery.cpfcnpj.js"></script>
    <script src="../../app-assets/vendors/js/forms/moment/moment.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/inputmask/jquery.inputmask.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/extended/typeahead/bloodhound.min.js"></script>
    <script src="../../app-assets/vendors/js/forms/extended/typeahead/handlebars.js"></script>
    <script src="../../app-assets/vendors/js/forms/extended/typeahead/typeahead.bundle.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/dataTables.responsive.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/responsive.bootstrap4.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/datatables.checkboxes.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/datatables.buttons.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/jszip.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/pdfmake.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/vfs_fonts.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/buttons.html5.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/buttons.print.min.js"></script>
    <script src="../../app-assets/vendors/js/tables/datatable/dataTables.rowGroup.min.js"></script>
    <script src="../../app-assets/vendors/js/sweetalert2/sweetalert2.all.min.js"></script>
    <script src="../../app-assets/vendors/js/pickers/flatpickr/flatpickr.min.js"></script>
    <script src="../../app-assets/vendors/js/pickers/pickadate/picker.js"></script>
    <script src="../../app-assets/vendors/js/pickers/pickadate/picker.date.js"></script>
    <script src="../../app-assets/vendors/js/pickers/pickadate/picker.time.js"></script>
    <script src="../../app-assets/vendors/js/pickers/pickadate/legacy.js"></script>
    <script src="../../app-assets/js/core/app-menu.min.js"></script>
    <script src="../../app-assets/js/core/app.min.js"></script>
    <script src="../../app-assets/js/scripts/forms/pickers/form-pickers.js"></script>
    <script src="../../app-assets/js/scripts/extensions/progresscircle.js"></script>
    <script src="../../app-assets/js/scripts/charts/chart-apex.js"></script>

    <script src="../../app-assets/vendors/js/daterangepicker/daterangepicker.js"></script>

    <script>

        $(function () {
            var isRtl = $('html').attr('data-textdirection') === 'rtl';
            var dt_filter_table = $('.dt-locolunas');
            if (dt_filter_table.length) {
                $('.dt-locolunas thead tr').clone(true).appendTo('.dt-locolunas thead');
                $('.dt-locolunas thead tr:eq(1) th').each(function (i) {
                    var title = $(this).text();
                    $(this).html('<input type="text" class="form-control form-control-sm" placeholder="Procure ' + title + '" />');
                    $('input', this).on('keyup change', function () {
                        if (dt_filter.column(i).search() !== this.value) {
                            dt_filter.column(i).search(this.value).draw();
                        }
                    });
                });


                var dt_filter = dt_filter_table.DataTable({
                    processing: true,
                    columns: [
                        { data: 'codigo' },
                        { data: 'nome' }
                    ],
                    dom: '<"d-flex justify-content-between align-items-center mx-0 row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>t<"d-flex justify-content-between mx-0 row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                    orderCellsTop: true,
                    language: {
                        lengthMenu: "Mostrando _MENU_ registros por página",
                        zeroRecords: "Nenhum encontrado - Desculpe",
                        info: "Mostrando página _PAGE_ de _PAGES_",
                        infoEmpty: "Nenhum registro encontrado",
                        infoFiltered: "(filtrando por _MAX_ de um total de registros)",
                        search: "Busca",
                        decimal: ",",
                        thousands: ".",
                        paginate: {
                            // remove previous & next text from pagination
                            previous: '&nbsp;',
                            next: '&nbsp;'
                        }
                    }
                });


            }
            // Filter form control to default size for all tables
            $('.dataTables_filter .form-control').removeClass('form-control-sm');
            $('.dataTables_length .form-select').removeClass('form-select-sm').removeClass('form-control-sm');

            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });
    </script>
</body>
<!-- END: Body-->

</html>